unit PosIExDKCUnit;

interface

function PosIEx_DKC_Pas_16_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_16_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_16_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_16_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_18_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_18_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_18_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_18_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_19_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_19_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_19_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_19_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_20_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_20_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_20_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_20_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_21_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_21_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_21_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_21_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_22_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_22_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_22_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_22_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_23_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_23_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_23_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_23_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_24_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_24_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_24_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_24_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_25_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_25_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_25_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_25_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_26_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_26_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_26_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_Pas_26_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_11_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_11_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_11_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_11_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_12_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_12_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_12_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_12_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_13_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_13_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_13_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_IA32_13_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_6_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_6_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_6_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_6_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosIEx_DKC_MMX_7_a(const SubStr, S: string; Offset: Integer = 1): Integer;

implementation

uses
 SysUtils;

var
 LookUpTable : array of Char;

procedure InitializeLookUpTable;
var
 I : Byte;
 S1, S2 : AnsiString;

begin
 SetLength(LookUpTable, 256);
 for I := 0 to 255 do
  begin
   S1 := Char(I);
   S2 := UpperCase(S1);
   LookUpTable[I] := S2[1];
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/8 2005

function PosIEx_DKC_Pas_16_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_16_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

procedure Filler49;
asm
 nop
end;

function PosIEx_DKC_Pas_16_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_16_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/8 2005

function PosIEx_DKC_Pas_18_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   //if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

procedure Filler4;
asm
 nop
end;

function PosIEx_DKC_Pas_18_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   //if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

procedure Filler5;
asm
 nop
end;

function PosIEx_DKC_Pas_18_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   //if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

procedure Filler6;
asm
 nop
end;

function PosIEx_DKC_Pas_18_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength, CharNo : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;
 pSubStrUpper : PChar;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   SetLength(SubStrUpper, SubStrLength);
   //if SubStrLength > 0 then
    begin
     pSubStrUpper := PChar(SubStrUpper);
     CharNo := 0;
     repeat
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
      if CharNo >= SubStrLength then
       Break;
      pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
      Inc(CharNo);
     until(CharNo >= SubStrLength);
    end;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_19_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_19_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_19_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_19_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if I1 + SubStrLength - 1 > StrLength then
       Exit;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_20_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[Result+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_20_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[Result+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_20_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[Result+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_20_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
    if SubStrUpperChar = UpperChar then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[Result+I2])];
       SubStrUpperChar := LookUpTable[Ord(SubStr[I2+1])];
       if UpperChar <> SubStrUpperChar then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[Result])];
    if SubStrUpperChar = UpperChar then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_21_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_21_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

procedure Filler7;
asm
 nop
end;

function PosIEx_DKC_Pas_21_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_21_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
        Break;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_22_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
      Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler8;
asm
 nop
end;

function PosIEx_DKC_Pas_22_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
      Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler9;
asm
 nop
end;

function PosIEx_DKC_Pas_22_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
      Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler10;
asm
 nop
end;

function PosIEx_DKC_Pas_22_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
      Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_23_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

procedure Filler11;
asm
 nop
end;

function PosIEx_DKC_Pas_23_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

procedure Filler12;
asm
 nop
end;

function PosIEx_DKC_Pas_23_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

procedure Filler13;
asm
 nop
end;

function PosIEx_DKC_Pas_23_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_24_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
       Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler14;
asm
 nop
end;

function PosIEx_DKC_Pas_24_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
       Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler15;
asm
 nop
end;

function PosIEx_DKC_Pas_24_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
       Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler16;
asm
 nop
end;

function PosIEx_DKC_Pas_24_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
 repeat
  if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
       Break;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_25_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if (SubStrFirstCharUpper = S[Result]) or
       (SubStrFirstCharUpper = LookUpTable[Ord(S[Result])]) then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_25_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if (SubStrFirstCharUpper = S[Result]) or
       (SubStrFirstCharUpper = LookUpTable[Ord(S[Result])]) then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

procedure Filler56;
asm
 nop
end;

function PosIEx_DKC_Pas_25_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if (SubStrFirstCharUpper = S[Result]) or
       (SubStrFirstCharUpper = LookUpTable[Ord(S[Result])]) then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_Pas_25_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if SubStrLength > 1 then
  begin
   if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
    Exit;
   Result := Offset;
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   repeat
    if (SubStrFirstCharUpper = S[Result]) or
       (SubStrFirstCharUpper = LookUpTable[Ord(S[Result])]) then
     begin
      if Result + SubStrLength - 1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       if S[Result+I2] <> SubStr[I2+1] then
        begin
         if LookUpTable[Ord(S[Result+I2])] <> LookUpTable[Ord(SubStr[I2+1])] then
          Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        Exit;
      until(False);
     end;
    Inc(Result);
   until(Result > StrLength);
   Result := 0;
  end
 else
  begin
   SubStrFirstCharUpper := LookUpTable[Ord(SubStr[1])];
   Result := Offset;
   repeat
    if SubStrFirstCharUpper = S[Result] then
     Exit;
    if SubStrFirstCharUpper = LookUpTable[Ord(S[Result])] then
     Exit;
    Inc(Result);
   until (Result > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/12 2005

function PosIEx_DKC_Pas_26_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper, Char1, Char2, Char3 : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 if ('a' <= SubStr[1]) and (SubStr[1] <= 'z') then
  SubStrFirstCharUpper := Char(Ord(SubStr[1])-32)
 else
  SubStrFirstCharUpper := SubStr[1];
 repeat
  if ('a' <= S[Result]) and (S[Result] <= 'z') then
   Char1 := Char(Ord(S[Result])-32)
  else
   Char1 := S[Result];
  if SubStrFirstCharUpper = Char1 then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      begin
       if ('a' <= S[Result+I2]) and (S[Result+I2] <= 'z') then
        Char2 := Char(Ord(S[Result+I2])-32)
       else
        Char2 := S[Result+I2];
       if ('a' <= SubStr[I2+1]) and (SubStr[I2+1] <= 'z') then
        Char3 := Char(Ord(SubStr[I2+1])-32)
       else
        Char3 := SubStr[I2+1];
       if Char2 <> Char3 then
        Break;
      end;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler57;
asm
 nop
end;

function PosIEx_DKC_Pas_26_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper, Char1, Char2, Char3 : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 if ('a' <= SubStr[1]) and (SubStr[1] <= 'z') then
  SubStrFirstCharUpper := Char(Ord(SubStr[1])-32)
 else
  SubStrFirstCharUpper := SubStr[1];
 repeat
  if ('a' <= S[Result]) and (S[Result] <= 'z') then
   Char1 := Char(Ord(S[Result])-32)
  else
   Char1 := S[Result];
  if SubStrFirstCharUpper = Char1 then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      begin
       if ('a' <= S[Result+I2]) and (S[Result+I2] <= 'z') then
        Char2 := Char(Ord(S[Result+I2])-32)
       else
        Char2 := S[Result+I2];
       if ('a' <= SubStr[I2+1]) and (SubStr[I2+1] <= 'z') then
        Char3 := Char(Ord(SubStr[I2+1])-32)
       else
        Char3 := SubStr[I2+1];
       if Char2 <> Char3 then
        Break;
      end;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler58;
asm
 nop
end;

function PosIEx_DKC_Pas_26_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper, Char1, Char2, Char3 : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 if ('a' <= SubStr[1]) and (SubStr[1] <= 'z') then
  SubStrFirstCharUpper := Char(Ord(SubStr[1])-32)
 else
  SubStrFirstCharUpper := SubStr[1];
 repeat
  if ('a' <= S[Result]) and (S[Result] <= 'z') then
   Char1 := Char(Ord(S[Result])-32)
  else
   Char1 := S[Result];
  if SubStrFirstCharUpper = Char1 then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      begin
       if ('a' <= S[Result+I2]) and (S[Result+I2] <= 'z') then
        Char2 := Char(Ord(S[Result+I2])-32)
       else
        Char2 := S[Result+I2];
       if ('a' <= SubStr[I2+1]) and (SubStr[I2+1] <= 'z') then
        Char3 := Char(Ord(SubStr[I2+1])-32)
       else
        Char3 := SubStr[I2+1];
       if Char2 <> Char3 then
        Break;
      end;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

procedure Filler59;
asm
 nop
end;

function PosIEx_DKC_Pas_26_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I2, SubStrLength, StrLength : Integer;
 SubStrFirstCharUpper, Char1, Char2, Char3 : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  Exit;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  Exit;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 Result := Offset;
 if ('a' <= SubStr[1]) and (SubStr[1] <= 'z') then
  SubStrFirstCharUpper := Char(Ord(SubStr[1])-32)
 else
  SubStrFirstCharUpper := SubStr[1];
 repeat
  if ('a' <= S[Result]) and (S[Result] <= 'z') then
   Char1 := Char(Ord(S[Result])-32)
  else
   Char1 := S[Result];
  if SubStrFirstCharUpper = Char1 then
   begin
    if Result + SubStrLength - 1 > StrLength then
     begin
      Result := 0;
      Exit;
     end;
    I2 := 1;
    repeat
     if (I2 >= SubStrLength) then
      Exit;
     if S[Result+I2] <> SubStr[I2+1] then
      begin
       if ('a' <= S[Result+I2]) and (S[Result+I2] <= 'z') then
        Char2 := Char(Ord(S[Result+I2])-32)
       else
        Char2 := S[Result+I2];
       if ('a' <= SubStr[I2+1]) and (SubStr[I2+1] <= 'z') then
        Char3 := Char(Ord(SubStr[I2+1])-32)
       else
        Char3 := SubStr[I2+1];
       if Char2 <> Char3 then
        Break;
      end;
     Inc(I2);
    until(False);
   end;
  Inc(Result);
 until(Result > StrLength);
 Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              6/10 2003
//Instructionset(s): IA32

function UpperCaseDKC_IA32_10_a(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 push  ebp
 mov   edi,edx
 mov   ebx,eax
 //Max := Length(S);
 call  System.@LStrLen
 //SetLength(Result, Max);
 mov   esi,eax
 mov   eax,edi
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit
 //PResult := Pointer(Result);
 mov   edi,[edi]
 //CharNo := 0;
 xor   eax,eax
 cmp   esi,4
 jb    @RepeatSmallBegin
 sub   esi,3
@RepeatBigBegin :
 mov   edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],edx
 add   eax,4
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatBigBegin
 add   esi,3
 cmp   esi,eax
 jbe   @Exit
@RepeatSmallBegin :
 movzx edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],dl
 add   eax,1
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatSmallBegin
@Exit :
 pop   ebp
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_10_b(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 push  ebp
 mov   edi,edx
 mov   ebx,eax
 //Max := Length(S);
 call  System.@LStrLen
 //SetLength(Result, Max);
 mov   esi,eax
 mov   eax,edi
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit
 //PResult := Pointer(Result);
 mov   edi,[edi]
 //CharNo := 0;
 xor   eax,eax
 cmp   esi,4
 jb    @RepeatSmallBegin
 sub   esi,3
@RepeatBigBegin :
 mov   edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],edx
 add   eax,4
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatBigBegin
 add   esi,3
 cmp   esi,eax
 jbe   @Exit
@RepeatSmallBegin :
 movzx edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],dl
 add   eax,1
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatSmallBegin
@Exit :
 pop   ebp
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_10_c(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 push  ebp
 mov   edi,edx
 mov   ebx,eax
 //Max := Length(S);
 call  System.@LStrLen
 //SetLength(Result, Max);
 mov   esi,eax
 mov   eax,edi
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit
 //PResult := Pointer(Result);
 mov   edi,[edi]
 //CharNo := 0;
 xor   eax,eax
 cmp   esi,4
 jb    @RepeatSmallBegin
 sub   esi,3
@RepeatBigBegin :
 mov   edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],edx
 add   eax,4
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatBigBegin
 add   esi,3
 cmp   esi,eax
 jbe   @Exit
@RepeatSmallBegin :
 movzx edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],dl
 add   eax,1
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatSmallBegin
@Exit :
 pop   ebp
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_10_d(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 push  ebp
 mov   edi,edx
 mov   ebx,eax
 //Max := Length(S);
 call  System.@LStrLen
 //SetLength(Result, Max);
 mov   esi,eax
 mov   eax,edi
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit
 //PResult := Pointer(Result);
 mov   edi,[edi]
 //CharNo := 0;
 xor   eax,eax
 cmp   esi,4
 jb    @RepeatSmallBegin
 sub   esi,3
@RepeatBigBegin :
 mov   edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],edx
 add   eax,4
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatBigBegin
 add   esi,3
 cmp   esi,eax
 jbe   @Exit
@RepeatSmallBegin :
 movzx edx,[ebx+eax]
 mov   ecx,7f7f7f7fh  //char3 = 7F
 and   ecx,edx        //char3 = char3 and char
 add   ecx,05050505h  //char3 = char3 + 05h
 and   ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add   ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov   ebp,edx        //char2 = char
 xor   ebp,-1         //char2 = char2 xor -1
 and   ebp,80808080h  //char2 = char2 and 80h
 and   ecx,ebp        //char3 = char3 and char2
 shr   ecx,2          //char3 = char3 shr 2
 and   ecx,20202020h  //char3 = char3 and 20h
 sub   edx, ecx       //char = char - char3
 mov   [edi+eax],dl
 add   eax,1
 //until(CharNo >= Max);
 cmp   esi,eax
 jnbe  @RepeatSmallBegin
@Exit :
 pop   ebp
 pop   edi
 pop   esi
 pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              7/10 2003
//Optimized for:     P4
//Instructionset(s): IA32

function UpperCaseDKC_IA32_18_a(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 mov   ebx,eax
 test  eax,eax
 jz    @LStrLenExit
 mov   eax,[eax-$04]
@LStrLenExit :
 mov   esi,eax
 mov   edi,edx
 //SetLength(Result, Max);
 mov   eax,edx
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit1
 //PResult := Pointer(Result);
 mov   edi,[edi]
 sub   ebx,1
 sub   edi,1
 mov   ecx,[LookUpTable]
@RepeatBegin :
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 //until(CharNo >= Max);
 jnbe  @RepeatBegin
@Exit1 :
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_18_b(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 mov   ebx,eax
 test  eax,eax
 jz    @LStrLenExit
 mov   eax,[eax-$04]
@LStrLenExit :
 mov   esi,eax
 mov   edi,edx
 //SetLength(Result, Max);
 mov   eax,edx
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit1
 //PResult := Pointer(Result);
 mov   edi,[edi]
 sub   ebx,1
 sub   edi,1
 mov   ecx,[LookUpTable]
@RepeatBegin :
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 //until(CharNo >= Max);
 jnbe  @RepeatBegin
@Exit1 :
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_18_c(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 mov   ebx,eax
 test  eax,eax
 jz    @LStrLenExit
 mov   eax,[eax-$04]
@LStrLenExit :
 mov   esi,eax
 mov   edi,edx
 //SetLength(Result, Max);
 mov   eax,edx
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit1
 //PResult := Pointer(Result);
 mov   edi,[edi]
 sub   ebx,1
 sub   edi,1
 mov   ecx,[LookUpTable]
@RepeatBegin :
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 //until(CharNo >= Max);
 jnbe  @RepeatBegin
@Exit1 :
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCaseDKC_IA32_18_d(const S: string): string;
asm
 push  ebx
 push  esi
 push  edi
 mov   ebx,eax
 test  eax,eax
 jz    @LStrLenExit
 mov   eax,[eax-$04]
@LStrLenExit :
 mov   esi,eax
 mov   edi,edx
 //SetLength(Result, Max);
 mov   eax,edx
 mov   edx,esi
 call  System.@LStrSetLength
 //if Max > 0 then
 test  esi,esi
 jbe   @Exit1
 //PResult := Pointer(Result);
 mov   edi,[edi]
 sub   ebx,1
 sub   edi,1
 mov   ecx,[LookUpTable]
@RepeatBegin :
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 jbe   @Exit1
 movzx edx,[ebx+esi]
 movzx edx,[ecx+edx]
 mov   [edi+esi],dl
 sub   esi,1
 //until(CharNo >= Max);
 jnbe  @RepeatBegin
@Exit1 :
 pop   edi
 pop   esi
 pop   ebx
end;

function UpperCase_DKC_MMX_33_a(const S: string): string;
const
 Const1 : Integer = $05050505;//Datatypes bigger than 4 byte can be misaligned
 Const2 : Integer = $20202020;
 Const3 : Integer = $65656565;

asm
 test      eax,eax
 jz        @NilString
 mov       ecx,[eax-$04]
 test      ecx,ecx
 jbe       @NonNilEmptyString
 push      ebx
 push      esi
 push      edi
 mov       ebx,eax
 mov       edi,edx
 mov       eax,edx
 mov       esi,ecx
 mov       edx,ecx
 //SetLength(Result, Max);
 call      System.@LStrSetLength
 //PResult := Pointer(Result);
 mov       edi,[edi]
 //CharNo := 0;
 xor       eax,eax
 cmp       esi,16
 jae       @BigBegin
 cmp       esi,3
 jbe       @ByteUpper
 sub       esi,3
 push      ebp
@RepeatBegin :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper :
 mov       ecx,[LookUpTable]
@ByteLoop :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop
 pop       edi
 pop       esi
 pop       ebx
 ret
@BigBegin :
 movd      mm2,Const1
 punpckldq mm2,mm2
 movd      mm3,Const2
 punpckldq mm3,mm3
 movd      mm4,Const3
 punpckldq mm4,mm4
 //UpperCase first 8 chars
 movq      mm0,[ebx]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi],mm0
 //Align   Source
 mov       ecx,ebx
 and       ecx,7
 add       eax,ecx
 sub       esi,7
@RepeatBigBegin :
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 //until(CharNo >= Max);
 cmp       esi,eax
 jnbe      @RepeatBigBegin
@RepeatBigEnd :
 emms
 add       esi,7
 cmp       esi,eax
 jbe       @Exit
@SmallBegin :
 cmp       esi,3
 jbe       @ByteUpper2
 sub       esi,3
 push      ebp
@RepeatBegin2 :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin2
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper2 :
 mov       ecx,[LookUpTable]
@ByteLoop2 :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop2
@Exit :
 pop       edi
 pop       esi
 pop       ebx
 ret
@NonNilEmptyString :
@NilString :
 //Return empty string
 mov       eax, edx
 xor       edx, edx
 call      System.@LStrSetLength
end;

function UpperCase_DKC_MMX_33_b(const S: string): string;
const
 Const1 : Integer = $05050505;//Datatypes bigger than 4 byte can be misaligned
 Const2 : Integer = $20202020;
 Const3 : Integer = $65656565;

asm
 test      eax,eax
 jz        @NilString
 mov       ecx,[eax-$04]
 test      ecx,ecx
 jbe       @NonNilEmptyString
 push      ebx
 push      esi
 push      edi
 mov       ebx,eax
 mov       edi,edx
 mov       eax,edx
 mov       esi,ecx
 mov       edx,ecx
 //SetLength(Result, Max);
 call      System.@LStrSetLength
 //PResult := Pointer(Result);
 mov       edi,[edi]
 //CharNo := 0;
 xor       eax,eax
 cmp       esi,16
 jae       @BigBegin
 cmp       esi,3
 jbe       @ByteUpper
 sub       esi,3
 push      ebp
@RepeatBegin :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper :
 mov       ecx,[LookUpTable]
@ByteLoop :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop
 pop       edi
 pop       esi
 pop       ebx
 ret
@BigBegin :
 movd      mm2,Const1
 punpckldq mm2,mm2
 movd      mm3,Const2
 punpckldq mm3,mm3
 movd      mm4,Const3
 punpckldq mm4,mm4
 //UpperCase first 8 chars
 movq      mm0,[ebx]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi],mm0
 //Align   Source
 mov       ecx,ebx
 and       ecx,7
 add       eax,ecx
 sub       esi,7
@RepeatBigBegin :
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 //until(CharNo >= Max);
 cmp       esi,eax
 jnbe      @RepeatBigBegin
@RepeatBigEnd :
 emms
 add       esi,7
 cmp       esi,eax
 jbe       @Exit
@SmallBegin :
 cmp       esi,3
 jbe       @ByteUpper2
 sub       esi,3
 push      ebp
@RepeatBegin2 :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin2
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper2 :
 mov       ecx,[LookUpTable]
@ByteLoop2 :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop2
@Exit :
 pop       edi
 pop       esi
 pop       ebx
 ret
@NonNilEmptyString :
@NilString :
 //Return empty string
 mov       eax, edx
 xor       edx, edx
 call      System.@LStrSetLength
end;

function UpperCase_DKC_MMX_33_c(const S: string): string;
const
 Const1 : Integer = $05050505;//Datatypes bigger than 4 byte can be misaligned
 Const2 : Integer = $20202020;
 Const3 : Integer = $65656565;

asm
 test      eax,eax
 jz        @NilString
 mov       ecx,[eax-$04]
 test      ecx,ecx
 jbe       @NonNilEmptyString
 push      ebx
 push      esi
 push      edi
 mov       ebx,eax
 mov       edi,edx
 mov       eax,edx
 mov       esi,ecx
 mov       edx,ecx
 //SetLength(Result, Max);
 call      System.@LStrSetLength
 //PResult := Pointer(Result);
 mov       edi,[edi]
 //CharNo := 0;
 xor       eax,eax
 cmp       esi,16
 jae       @BigBegin
 cmp       esi,3
 jbe       @ByteUpper
 sub       esi,3
 push      ebp
@RepeatBegin :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper :
 mov       ecx,[LookUpTable]
@ByteLoop :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop
 pop       edi
 pop       esi
 pop       ebx
 ret
@BigBegin :
 movd      mm2,Const1
 punpckldq mm2,mm2
 movd      mm3,Const2
 punpckldq mm3,mm3
 movd      mm4,Const3
 punpckldq mm4,mm4
 //UpperCase first 8 chars
 movq      mm0,[ebx]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi],mm0
 //Align   Source
 mov       ecx,ebx
 and       ecx,7
 add       eax,ecx
 sub       esi,7
@RepeatBigBegin :
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 //until(CharNo >= Max);
 cmp       esi,eax
 jnbe      @RepeatBigBegin
@RepeatBigEnd :
 emms
 add       esi,7
 cmp       esi,eax
 jbe       @Exit
@SmallBegin :
 cmp       esi,3
 jbe       @ByteUpper2
 sub       esi,3
 push      ebp
@RepeatBegin2 :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin2
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper2 :
 mov       ecx,[LookUpTable]
@ByteLoop2 :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop2
@Exit :
 pop       edi
 pop       esi
 pop       ebx
 ret
@NonNilEmptyString :
@NilString :
 //Return empty string
 mov       eax, edx
 xor       edx, edx
 call      System.@LStrSetLength
end;

function UpperCase_DKC_MMX_33_d(const S: string): string;
const
 Const1 : Integer = $05050505;//Datatypes bigger than 4 byte can be misaligned
 Const2 : Integer = $20202020;
 Const3 : Integer = $65656565;

asm
 test      eax,eax
 jz        @NilString
 mov       ecx,[eax-$04]
 test      ecx,ecx
 jbe       @NonNilEmptyString
 push      ebx
 push      esi
 push      edi
 mov       ebx,eax
 mov       edi,edx
 mov       eax,edx
 mov       esi,ecx
 mov       edx,ecx
 //SetLength(Result, Max);
 call      System.@LStrSetLength
 //PResult := Pointer(Result);
 mov       edi,[edi]
 //CharNo := 0;
 xor       eax,eax
 cmp       esi,16
 jae       @BigBegin
 cmp       esi,3
 jbe       @ByteUpper
 sub       esi,3
 push      ebp
@RepeatBegin :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper :
 mov       ecx,[LookUpTable]
@ByteLoop :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop
 pop       edi
 pop       esi
 pop       ebx
 ret
@BigBegin :
 movd      mm2,Const1
 punpckldq mm2,mm2
 movd      mm3,Const2
 punpckldq mm3,mm3
 movd      mm4,Const3
 punpckldq mm4,mm4
 //UpperCase first 8 chars
 movq      mm0,[ebx]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi],mm0
 //Align   Source
 mov       ecx,ebx
 and       ecx,7
 add       eax,ecx
 sub       esi,7
@RepeatBigBegin :
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 cmp       esi,eax
 jbe       @RepeatBigEnd
 movq      mm0,[ebx+eax]
 movq      mm1,mm0
 paddb     mm1,mm2        //char3 = char3 + 05h
 pcmpgtb   mm1,mm4
 pand      mm1,mm3        //char3 = char3 and 7Fh
 psubb     mm0,mm1        //char = char - char3
 movq      [edi+eax],mm0
 add       eax,8
 //until(CharNo >= Max);
 cmp       esi,eax
 jnbe      @RepeatBigBegin
@RepeatBigEnd :
 emms
 add       esi,7
 cmp       esi,eax
 jbe       @Exit
@SmallBegin :
 cmp       esi,3
 jbe       @ByteUpper2
 sub       esi,3
 push      ebp
@RepeatBegin2 :
 mov       edx,[ebx+eax]
 mov       ecx,7f7f7f7fh  //char3 = 7F
 and       ecx,edx        //char3 = char3 and char
 add       ecx,05050505h  //char3 = char3 + 05h
 and       ecx,7f7f7f7fh  //char3 = char3 and 7Fh
 add       ecx,1a1a1a1ah  //char3 = char3 + 1Ah
 mov       ebp,edx        //char2 = char
 xor       ebp,-1         //char2 = char2 xor -1
 and       ebp,80808080h  //char2 = char2 and 80h
 and       ecx,ebp        //char3 = char3 and char2
 shr       ecx,2          //char3 = char3 shr 2
 and       ecx,20202020h  //char3 = char3 and 20h
 sub       edx,ecx        //char = char - char3
 mov       [edi+eax],edx
 add       eax,4
 cmp       esi,eax
 jnbe      @RepeatBegin2
 pop       ebp
 add       esi,3
 cmp       esi,eax
 jbe       @Exit
@ByteUpper2 :
 mov       ecx,[LookUpTable]
@ByteLoop2 :
 movzx     edx,[ebx+eax]
 movzx     edx,[ecx+edx]
 mov       [edi+eax],dl
 add       eax,1
 cmp       esi,eax
 jnbe      @ByteLoop2
@Exit :
 pop       edi
 pop       esi
 pop       ebx
 ret
@NonNilEmptyString :
@NilString :
 //Return empty string
 mov       eax, edx
 xor       edx, edx
 call      System.@LStrSetLength
end;

//Author:            Dennis Kjaer Christensen
//Date:              13/8 2005
//Instructionset(s): IA32

function PosIEx_DKC_IA32_1_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_a(SubStr);
   SUpper := UpperCaseDKC_IA32_10_a(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler60;
asm
 nop
end;

function PosIEx_DKC_IA32_1_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_b(SubStr);
   SUpper := UpperCaseDKC_IA32_10_b(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler17;
asm
 nop
end;

function PosIEx_DKC_IA32_1_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_c(SubStr);
   SUpper := UpperCaseDKC_IA32_10_c(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler18;
asm
 nop
end;

function PosIEx_DKC_IA32_1_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_d(SubStr);
   SUpper := UpperCaseDKC_IA32_10_d(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

function PosIEx_DKC_IA32_2_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_a(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed 
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler19;
asm
 nop
end;

function PosIEx_DKC_IA32_2_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_b(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler20;
asm
 nop
end;

function PosIEx_DKC_IA32_2_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_c(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed 
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler21;
asm
 nop
end;

function PosIEx_DKC_IA32_2_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCaseDKC_IA32_10_d(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/8 2005
//Instructionset(s): IA32

function PosIEx_DKC_IA32_3_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_10_a(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler22;
asm
 nop
end;

function PosIEx_DKC_IA32_3_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_10_b(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler23;
asm
 nop
end;

function PosIEx_DKC_IA32_3_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_10_c(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler24;
asm
 nop
end;

function PosIEx_DKC_IA32_3_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_10_d(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              14/8 2005
//Instructionset(s): IA32

function PosIEx_DKC_IA32_4_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_18_a(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler25;
asm
 nop
end;

function PosIEx_DKC_IA32_4_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_18_b(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler26;
asm
 nop
end;

function PosIEx_DKC_IA32_4_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_18_c(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler27;
asm
 nop
end;

function PosIEx_DKC_IA32_4_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCaseDKC_IA32_18_d(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/8 2005
//Instructionset(s): IA32

function PosIEx_DKC_IA32_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCaseDKC_IA32_18_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_IA32_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCaseDKC_IA32_18_b(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_IA32_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCaseDKC_IA32_18_c(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_IA32_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCaseDKC_IA32_18_d(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/8 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_6a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
push ebp
mov  ebp,esp
add  esp,-$18
push ebx
push esi
push edi
xor  ebx,ebx
mov  [ebp-$04],ebx
mov  [ebp-$08],ecx
mov  esi,edx
mov  edi,eax
//xor eax,eax
//push ebp
//push $0047063c
//push dword ptr fs:[eax]
//mov fs:[eax],esp
//Result := 0;
xor eax,eax
mov [ebp-$0c],eax
//if (Offset <= 0) then
cmp dword ptr [ebp-$08],$00
jle @Exit//$004709c6
//if S = '' then
test esi,esi
jz @Exit
//StrLength := PInteger(Integer(S)-4)^;
mov eax,esi
sub eax,$04
mov eax,[eax]
mov [ebp-$14],eax
//if SubStr = '' then
test edi,edi
jz @Exit
//SubStrLength := PInteger(Integer(SubStr)-4)^;
mov eax,edi
sub eax,$04
mov eax,[eax]
mov [ebp-$10],eax
//if (SubStrLength <= 0) then
cmp dword ptr [ebp-$10],$00
jle @Exit
//if (StrLength <= 0) then
cmp dword ptr [ebp-$14],$00
jle @Exit
//if (Integer(Offset) > StrLength) then
mov eax,[ebp-$08]
cmp eax,[ebp-$14]
jnle @Exit
//if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
mov edx,[ebp-$14]
sub edx,eax
inc edx
cmp edx,[ebp-$10]
jl @Exit
//SetLength(SubStrUpper, SubStrLength);
lea eax,[ebp-$04]
mov edx,[ebp-$10]
call System.@LStrSetLength
//pSubStrUpper := PChar(SubStrUpper);
mov eax,[ebp-$04]
call System.@LStrToPChar
mov [ebp-$18],eax
//CharNo := 0;
xor eax,eax
@UpperCaseLoopStart :
//pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
movzx edx,[edi+eax]
mov   ecx,[LookUpTable]
movzx edx,[ecx+edx]
mov ecx,[ebp-$18]
mov [ecx+eax],dl
//Inc(CharNo);
inc eax
//until(CharNo >= SubStrLength);
cmp eax,[ebp-$10]
jl @UpperCaseLoopStart
//I1 := Offset;
mov eax,[ebp-$08]
@OuterLoopStart :
//UpperChar := LookUpTable[Ord(S[I1])];
movzx edx,[esi+eax-$01]
mov   ecx,[LookUpTable]
movzx ecx,[ecx+edx]
//if SubStrUpper[1] = UpperChar then
mov edx,[ebp-$04]
cmp cl,[edx]
jnz @IfEnd1
//if I1 + SubStrLength - 1 > StrLength then
mov edx,[ebp-$10]
add edx,eax
dec edx
cmp edx,[ebp-$14]
jnle @Exit
//if SubStrLength > 1 then
cmp dword ptr [ebp-$10],$01
jle @IfEnd2
//I2 := 1;
mov edx,$00000001
@InnerLoopStart :
//UpperChar := LookUpTable[Ord(S[I1+I2])];
lea ecx,[edx+eax]
movzx ecx,[esi+ecx-$01]
mov ebx,[LookUpTable]
movzx ecx,[ebx+ecx]
//if UpperChar <> SubStrUpper[I2+1] then
mov ebx,[ebp-$04]
cmp cl,[ebx+edx]
//Break;
jnz @InnerLoopEnd
//Inc(I2);
inc edx
//if (I2 >= SubStrLength) then
cmp edx,[ebp-$10]
jl @InnerLoopStart
//Result := I1;
mov [ebp-$0c],eax
//Exit;
jmp @Exit

jmp @InnerLoopStart
@InnerLoopEnd :
jmp @IfEnd1
//else
@IfEnd2 :
//Result := I1;
mov [ebp-$0c],eax
//Exit;
jmp @Exit
@IfEnd1 :

//Inc(I1);
inc eax
//until(I1 > StrLength);
cmp eax,[ebp-$14]
jle @OuterLoopStart
xor eax,eax
@Exit :
//pop edx
//pop ecx
//pop ecx
//mov fs:[eax],edx
//push $004709e3
//lea eax,[ebp-$04]
//call @LStrClr
//ret
//jmp @HandleFinally
//jmp $004709d3
mov eax,[ebp-$0c]
//end;
pop edi
pop esi
pop ebx
mov esp,ebp
pop ebp
//ret
end;

function PosIEx_DKC_IA32_6b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  add   esp,-$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  mov   esi,edx
  mov   edi,eax
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  cmp   dword ptr [ebp-$08],$00
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,esi
  sub   eax,$04
  mov   eax,[eax]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,edi
  sub   eax,$04
  mov   eax,[eax]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   dword ptr [ebp-$10],$00
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],$00
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  mov   ecx,[ebp-$18]
  mov   [ecx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-$01]
  mov   ecx,[LookUpTable]
  movzx ecx,[ecx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],$01
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,$00000001
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  //Break;
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  //Exit;
  jmp   @Exit
  jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
  //else
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  //Exit;
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  //end;
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
  //ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/8 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_6_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  add   esp,-$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  mov   esi,edx
  mov   edi,eax
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  cmp   dword ptr [ebp-$08],0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,esi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,edi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   dword ptr [ebp-$10],0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  mov   ecx,[ebp-$18]
  mov   [ecx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ecx,[LookUpTable]
  movzx ecx,[ecx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_6_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  add   esp,-$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  mov   esi,edx
  mov   edi,eax
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  cmp   dword ptr [ebp-$08],0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,esi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,edi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   dword ptr [ebp-$10],0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  mov   ecx,[ebp-$18]
  mov   [ecx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ecx,[LookUpTable]
  movzx ecx,[ecx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_6_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  add   esp,-$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  mov   esi,edx
  mov   edi,eax
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  cmp   dword ptr [ebp-$08],0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,esi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,edi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   dword ptr [ebp-$10],0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  mov   ecx,[ebp-$18]
  mov   [ecx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ecx,[LookUpTable]
  movzx ecx,[ecx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_6_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  add   esp,-$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  mov   esi,edx
  mov   edi,eax
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  cmp   dword ptr [ebp-$08],0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,esi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,edi
  sub   eax,4
  mov   eax,[eax]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   dword ptr [ebp-$10],0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  mov   ecx,[ebp-$18]
  mov   [ecx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ecx,[LookUpTable]
  movzx ecx,[ecx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/8 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_7_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  //cmp   dword ptr [ebp-$08],0
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  //mov   eax,esi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  //mov   eax,edi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   dword ptr [ebp-$10],0
  cmp   eax,0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  //mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  //mov   ecx,[ebp-$18]
  mov   ebx,[ebp-$18]
  //mov   [ecx+eax],dl
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  //mov   ecx,[LookUpTable]
  mov   ebx,[LookUpTable]
  //movzx ecx,[ecx+edx]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  //jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  //xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_7_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  //cmp   dword ptr [ebp-$08],0
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  //mov   eax,esi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  //mov   eax,edi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   dword ptr [ebp-$10],0
  cmp   eax,0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  //mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  //mov   ecx,[ebp-$18]
  mov   ebx,[ebp-$18]
  //mov   [ecx+eax],dl
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  //mov   ecx,[LookUpTable]
  mov   ebx,[LookUpTable]
  //movzx ecx,[ecx+edx]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  //jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  //xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler50;
asm
 nop
end;

function PosIEx_DKC_IA32_7_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  //cmp   dword ptr [ebp-$08],0
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  //mov   eax,esi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  //mov   eax,edi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   dword ptr [ebp-$10],0
  cmp   eax,0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  //mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  //mov   ecx,[ebp-$18]
  mov   ebx,[ebp-$18]
  //mov   [ecx+eax],dl
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  //mov   ecx,[LookUpTable]
  mov   ebx,[LookUpTable]
  //movzx ecx,[ecx+edx]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  //jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  //xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_7_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$04],ebx
  mov   [ebp-$08],ecx
  xor   eax,eax
  mov   [ebp-$0c],eax
  //if (Offset <= 0) then
  //cmp   dword ptr [ebp-$08],0
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  //mov   eax,esi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  //mov   eax,edi
  //sub   eax,4
  //mov   eax,[eax]
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   dword ptr [ebp-$10],0
  cmp   eax,0
  jle   @Exit
  //if (StrLength <= 0) then
  cmp   dword ptr [ebp-$14],0
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  //mov   ecx,[LookUpTable]
  movzx edx,[ecx+edx]
  //mov   ecx,[ebp-$18]
  mov   ebx,[ebp-$18]
  //mov   [ecx+eax],dl
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  //mov   ecx,[LookUpTable]
  mov   ebx,[LookUpTable]
  //movzx ecx,[ecx+edx]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @InnerLoopEnd
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
  //jmp   @InnerLoopStart
@InnerLoopEnd :
  jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
  //xor   eax,eax
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/8 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_8_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //xor   eax,eax
  //if (Offset <= 0) then
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  cmp   eax,0
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   eax,0
  jle   @Exit
  ////if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  //jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$18]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  //mov   ebx,[ebp-$18]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  //jnz   @InnerLoopEnd
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
//@InnerLoopEnd :
  //jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler51;
asm
 nop
end;

function PosIEx_DKC_IA32_8_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //xor   eax,eax
  //if (Offset <= 0) then
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  cmp   eax,0
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   eax,0
  jle   @Exit
  ////if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  //jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$18]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  //mov   ebx,[ebp-$18]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  //jnz   @InnerLoopEnd
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
//@InnerLoopEnd :
  //jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler52;
asm
 nop
end;

function PosIEx_DKC_IA32_8_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //xor   eax,eax
  //if (Offset <= 0) then
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  cmp   eax,0
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   eax,0
  jle   @Exit
  ////if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  //jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$18]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  //mov   ebx,[ebp-$18]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  //jnz   @InnerLoopEnd
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
//@InnerLoopEnd :
  //jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler53;
asm
 nop
end;

function PosIEx_DKC_IA32_8_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //xor   eax,eax
  //if (Offset <= 0) then
  cmp   ecx,0
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  cmp   eax,0
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  cmp   eax,0
  jle   @Exit
  ////if (StrLength <= 0) then
  //cmp   dword ptr [ebp-$14],0
  //jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,[ebp-$08]
  cmp   eax,[ebp-$14]
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //call  System.@LStrToPChar
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$18]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  //mov   ebx,[ebp-$18]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @Exit
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-$01]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  //jnz   @InnerLoopEnd
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
//@InnerLoopEnd :
  //jmp   @IfEnd1
@IfEnd2 :
  //Result := I1;
  mov   [ebp-$0c],eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,[ebp-$0c]
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              30/8 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_9_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  //cmp   ecx,0
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  //mov   eax,[ebp-$08]
  mov   eax,ecx
  //cmp   eax,[ebp-$14]
  mov   edx,[ebp-$14]
  //cmp   ecx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  //mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  //mov   ebx,[ebp-$18]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax 
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  //mov   ebx,[ebp-$0c]
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  //mov   eax,[ebp-$0c]
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_9_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  //cmp   ecx,0
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  //mov   eax,[ebp-$08]
  mov   eax,ecx
  //cmp   eax,[ebp-$14]
  mov   edx,[ebp-$14]
  //cmp   ecx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  //mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  //mov   ebx,[ebp-$18]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax 
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  //mov   ebx,[ebp-$0c]
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  //mov   eax,[ebp-$0c]
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler54;
asm
 nop
end;

function PosIEx_DKC_IA32_9_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  //cmp   ecx,0
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  //mov   eax,[ebp-$08]
  mov   eax,ecx
  //cmp   eax,[ebp-$14]
  mov   edx,[ebp-$14]
  //cmp   ecx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  //mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  //mov   ebx,[ebp-$18]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax 
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  //mov   ebx,[ebp-$0c]
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  //mov   eax,[ebp-$0c]
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_9_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  //cmp   ecx,0
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  //cmp   eax,0
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  //mov   eax,[ebp-$08]
  mov   eax,ecx
  //cmp   eax,[ebp-$14]
  mov   edx,[ebp-$14]
  //cmp   ecx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  //mov   edx,[ebp-$14]
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  //mov   ebx,[ebp-$18]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx-1]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  //mov   [ebp-$0c],eax
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  //mov   ebx,[ebp-$0c]
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  //mov   eax,[ebp-$0c]
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              1/9 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_10_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  //mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
  dec   esi
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  //movzx edx,[esi+eax-1]
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  //movzx ecx,[esi+ecx-1]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_10_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  //mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
  dec   esi
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  //movzx edx,[esi+eax-1]
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  //movzx ecx,[esi+ecx-1]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_10_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  //mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
  dec   esi
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  //movzx edx,[esi+eax-1]
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  //movzx ecx,[esi+ecx-1]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_10_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  mov   [ebp-$04],ebx
  //mov   [ebp-$0c],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [ebp-$08],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [ebp-$14],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [ebp-$10],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[ebp-$14]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[ebp-$10]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[ebp-$04]
  mov   edx,[ebp-$10]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[ebp-$04]
  //mov   [ebp-$18],eax
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[ebp-$04]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,[ebp-$10]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[ebp-$08]
  mov   ebx,[LookUpTable]
  dec   esi
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  //movzx edx,[esi+eax-1]
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,[ebp-$04]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[ebp-$10]
  add   edx,eax
  dec   edx
  cmp   edx,[ebp-$14]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [ebp-$10],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  //movzx ecx,[esi+ecx-1]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,[ebp-$04]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[ebp-$10]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[ebp-$14]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[ebp-$04]
  call  System.@LStrClr
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              1/9 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_11a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24//$18
  push  ebx
  push  esi
  push  edi
  xor   ebx,ebx
  //mov   [ebp-$04],ebx -4 -> +32
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  //mov   [ebp-$08],ecx
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  //mov   [ebp-$14],eax
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  //mov   [ebp-$10],eax
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  //mov   edx,[ebp-$14]
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  //cmp   edx,[ebp-$10]
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  //lea   eax,[ebp-$04]
  lea   eax,[esp+$20]
  //mov   edx,[ebp-$10]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  //mov   eax,[ebp-$04]
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  //mov   ebx,[ebp-$04]
  mov   ebx,[esp+$20]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  //cmp   eax,[ebp-$10]
  cmp   eax,[esp+$14]
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  //mov   eax,[ebp-$08]
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  //mov   edx,[ebp-$04]
  mov   edx,[esp+$20]
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  //mov   edx,[ebp-$10]
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  //cmp   edx,[ebp-$14]
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  //cmp   dword ptr [ebp-$10],1
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  //mov   ebx,[ebp-$04]
  mov   ebx,[esp+$20]
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  //cmp   edx,[ebp-$10]
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  //cmp   eax,[ebp-$14]
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  //lea   eax,[ebp-$04]
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              1/9 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_11_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  //cmp   eax,[esp+$14]
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  //mov   edx,[esp+$20]
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  //mov   ebx,[esp+$20]
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_11_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  //cmp   eax,[esp+$14]
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  //mov   edx,[esp+$20]
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  //mov   ebx,[esp+$20]
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_11_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  //cmp   eax,[esp+$14]
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  //mov   edx,[esp+$20]
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  //mov   ebx,[esp+$20]
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_11_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  //cmp   eax,[esp+$14]
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  //mov   edx,[esp+$20]
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  //mov   ebx,[esp+$20]
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              1/9 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_12_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_12_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_12_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_IA32_12_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  mov   ebx,[LookUpTable]
  dec   esi
  mov   ebp,[esp+$20]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  mov   ebx,[LookUpTable]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  mov   ebx,ebp
  cmp   cl,[ebx+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/12 2005
//Instruction sets   IA32

function PosIEx_DKC_IA32_13_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit1
  //if S = '' then
  test  esi,esi
  jz    @Exit1
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit1
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esi-4]
  cmp   ecx,edx
  jnle  @Exit1
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[edi-4]
  jl    @Exit1
  xor ebx,ebx
  mov   [esp+$20],ebx
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[edi-4]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   ebx,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebp,[edi-4]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  dec   esi
  mov   ebp,[esp+$20]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[edi-4]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [edi-4],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  cmp   cl,[ebp+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[edi-4]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
@Exit1 :
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler1;
asm
 nop
end;

function PosIEx_DKC_IA32_13_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit1
  //if S = '' then
  test  esi,esi
  jz    @Exit1
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit1
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esi-4]
  cmp   ecx,edx
  jnle  @Exit1
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[edi-4]
  jl    @Exit1
  xor ebx,ebx
  mov   [esp+$20],ebx
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[edi-4]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   ebx,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebp,[edi-4]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  dec   esi
  mov   ebp,[esp+$20]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[edi-4]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [edi-4],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  cmp   cl,[ebp+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[edi-4]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
@Exit1 :
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler2;
asm
 nop
end;

function PosIEx_DKC_IA32_13_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit1
  //if S = '' then
  test  esi,esi
  jz    @Exit1
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit1
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esi-4]
  cmp   ecx,edx
  jnle  @Exit1
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[edi-4]
  jl    @Exit1
  xor ebx,ebx
  mov   [esp+$20],ebx
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[edi-4]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   ebx,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebp,[edi-4]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  dec   esi
  mov   ebp,[esp+$20]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[edi-4]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [edi-4],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  cmp   cl,[ebp+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[edi-4]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
@Exit1 :
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

procedure Filler3;
asm
 nop
end;

function PosIEx_DKC_IA32_13_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit1
  //if S = '' then
  test  esi,esi
  jz    @Exit1
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit1
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit1
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esi-4]
  cmp   ecx,edx
  jnle  @Exit1
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[edi-4]
  jl    @Exit1
  xor ebx,ebx
  mov   [esp+$20],ebx
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[edi-4]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   ebx,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebp,[edi-4]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  dec   esi
  mov   ebp,[esp+$20]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[edi-4]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [edi-4],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  cmp   cl,[ebp+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[edi-4]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
@Exit1 :
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

function PosIEx_DKC_MMX_1_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   SUpper := UpperCase_DKC_MMX_33_a(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler28;
asm
 nop
end;

function PosIEx_DKC_MMX_1_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_b(SubStr);
   SUpper := UpperCase_DKC_MMX_33_b(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler29;
asm
 nop
end;

function PosIEx_DKC_MMX_1_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_c(SubStr);
   SUpper := UpperCase_DKC_MMX_33_c(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler30;
asm
 nop
end;

function PosIEx_DKC_MMX_1_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SUpper, SubStrUpper : String;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_d(SubStr);
   SUpper := UpperCase_DKC_MMX_33_d(S);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if SUpper[I1+I2] <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStrUpper[1] = SUpper[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

function PosIEx_DKC_MMX_2_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler31;
asm
 nop
end;

function PosIEx_DKC_MMX_2_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_b(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler32;
asm
 nop
end;

function PosIEx_DKC_MMX_2_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_c(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler33;
asm
 nop
end;

function PosIEx_DKC_MMX_2_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_d(SubStr);
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/8 2005
//Instructionset(s): IA32, MMX

function PosIEx_DKC_MMX_3_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler34;
asm
 nop
end;

function PosIEx_DKC_MMX_3_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_b(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler35;
asm
 nop
end;

function PosIEx_DKC_MMX_3_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_c(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler36;
asm
 nop
end;

function PosIEx_DKC_MMX_3_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_d(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1 + SubStrLength - 1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     //CharPosIEx
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              22/8 2005
//Instructionset(s): IA32, MMX

function PosIEx_DKC_MMX_4_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler37;
asm
 nop
end;

function PosIEx_DKC_MMX_4_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_b(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler38;
asm
 nop
end;

function PosIEx_DKC_MMX_4_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_c(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

procedure Filler48;
asm
 nop
end;

function PosIEx_DKC_MMX_4_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SearchChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  Exit;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     SubStrUpper := UpperCase_DKC_MMX_33_d(SubStr);
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      //Uppercase chars as needed
      UpperChar := LookUpTable[Ord(S[I1])];
      if SubStrUpper[1] = UpperChar then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         //Uppercase chars as needed
         UpperChar := LookUpTable[Ord(S[I1+I2])];
         if UpperChar <> SubStrUpper[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     SearchChar := LookUpTable[Ord(SubStr[1])];
     Result := Offset;
     repeat
      UpperChar := LookUpTable[Ord(S[Result])];
      if SearchChar = UpperChar then
       Exit;
      Inc(Result);
     until (Result > StrLength);
     Result := 0;
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/8 2005
//Instructionset(s): IA32, MMX

function PosIEx_DKC_MMX_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_MMX_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_MMX_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

function PosIEx_DKC_MMX_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar, SubStrUpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   SubStrUpperChar := LookUpTable[Ord(SubStr[1])];
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpperChar = UpperChar then
     begin
      Result := I1;
      Exit;
     end;
    Inc(I1);
   until (I1 > StrLength);
   Result := 0;
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              14/12 2005
//Instructionset(s): IA32, MMX

function CharPosIEx_DKC_MMX_4(SearchChar : Char;
                              const S: string;
                              Offset: Integer = 1) : Integer;
const
 Const1 : Integer = $05050505;
 Const2 : Integer = $20202020;
 Const3 : Integer = $65656565;

asm
   push      ebx
   push      edi
   push      esi
   //if OffSet <= 0 then
   test      ecx,ecx
   jle       @ExitResult0
   //if StrLenght > 0 then
   test      edx,edx
   jz        @ExitResult0
   //StrLenght := Length(Str);
   mov       edi,[edx-4]
   test      edi,edi
   jz        @Else1Begin
   cmp       edi,ecx
   jb        @ExitResult0
   mov       esi,[LookUpTable]
   movzx     eax,al
   movzx     eax,[esi+eax]
   mov       esi,edi
   sub       esi,ecx
   cmp       esi,8
   jae       @BigStr
   //SmallStr :
   dec       ecx
   sub       edx,1
 @RepeatBegin :
   //Inc(I);
   add       ecx,1
   //CharUpper := LookUpTable[Ord(S[Result])];
   movzx     ebx,[edx+ecx]
   mov       esi,[LookUpTable]
   movzx     ebx,[esi+ebx]
   //until((Str[I] = Chr) or (I > StrLenght));
   cmp       al,bl
   jz        @Exit
   cmp       edi,ecx
   ja        @RepeatBegin
   //Result := 0;
   xor       eax,eax
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Exit :
   mov       eax,ecx
   pop       esi
   pop       edi
   pop       ebx
   ret
 @BigStr :
   mov       ah,al
   shl       eax,8
   mov       al,ah
   shl       eax,8
   mov       al,ah
   movd      mm0,eax
   movq      mm1,mm0
   psllq     mm1,32
   por       mm0,mm1
   movq      mm5,mm0
   mov       esi,ecx
   dec       esi
   //StrLenght := Length(Str);
   shr       edi,3
   add       edi,edi
   add       edi,edi
   add       edi,edi
   sub       edi,7
   movd      mm2,Const1
   punpckldq mm2,mm2
   movd      mm3,Const2
   punpckldq mm3,mm3
   movd      mm4,Const3
   punpckldq mm4,mm4
 @LoopStart :
   movq      mm0,[edx+esi]
   movq      mm1,mm0
   paddb     mm1,mm2        //char3 = char3 + 05h
   pcmpgtb   mm1,mm4
   pand      mm1,mm3        //char3 = char3 and 7Fh
   psubb     mm0,mm1        //char = char - char3
   pcmpeqb   mm0,mm5
   packsswb  mm0,mm0
   movd      ebx,mm0
   add       esi,8
   test      ebx,ebx
   jnz       @Found
   cmp       esi,edi
   jb        @LoopStart
   add       edi,7
   emms
   jmp       @BigNotFound
 @Found :
   emms
   //There is a match, but where? Find the leftmost match.
   test      bl, bl
   jnz       @Char1or2Match
   test      bh, bh
   jnz       @Char3or4Match
   shr       ebx, 16
   test      bl, bl
   jnz       @Char5or6Match
   test      bh, bh
   jnz       @Char7or8Match
 @Char1or2Match :
   cmp       bl, 255
   je        @Char1Match
   cmp       bl, 127
   jbe       @Char1Match
   jmp       @Char2Match
 @Char3or4Match :
   cmp       bl, 255
   je        @Char3Match
   cmp       bh, 255
   je        @Char3Match
   cmp       bh, 127
   jbe       @Char3Match
   jmp       @Char4Match
 @Char5or6Match :
   cmp       bl, 255
   je        @Char5Match
   cmp       bl, 127
   jbe       @Char5Match
   jmp       @Char6Match
 @Char7or8Match :
   cmp       bl, 255
   je        @Char7Match
   cmp       bh, 255
   je        @Char7Match
   cmp       bh, 127
   jbe       @Char7Match
   jmp       @Char8Match
 @Char1Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 1
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char2Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 2
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char3Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 3
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char4Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 4
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char5Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 5
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char6Match :
   sub       esi, 8
   mov       eax, esi
   add       eax, 6
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char7Match :
   sub       esi,8
   mov       eax,esi
   add       eax,7
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Char8Match :
   sub       esi,8
   mov       eax,esi
   add       eax,8
   //emms
   pop       esi
   pop       edi
   pop       ebx
   ret
 @BigNotFound :
   //Search the rest - if any
   mov       edi,[edx-4]
   cmp       esi,edi
   je        @Else3Begin//No rest
   sub       edx,1
 @BigRepeatBegin :
   //Inc(I);
   add       esi,1
   //CharUpper := LookUpTable[Ord(S[Result])];
   movzx     ebx,[edx+esi]
   mov       ecx,[LookUpTable]
   movzx     ebx,[ecx+ebx]
   //until((Str[I] = Chr) or (I > StrLenght));
   cmp       al,bl
   jz        @FoundSmallAfterBig
   cmp       edi,esi
   ja        @BigRepeatBegin
   //pop       esi
 @Else1Begin :
 @ExitResult0 :
   //Result := 0;
   xor       eax,eax
   pop       esi
   pop       edi
   pop       ebx
   ret
 @Else3Begin :
   //Result := 0;
   xor       eax,eax
   pop       esi
   pop       edi
   pop       ebx
   ret
 @FoundSmallAfterBig :
   mov       eax,esi
   pop       esi
   pop       edi
   pop       ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/12 2005
//Instructionset(s): IA32, MMX

function PosIEx_DKC_MMX_6_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   Result := CharPosIEx_DKC_MMX_4(SubStr[1], S, Offset);
  end;
end;

function PosIEx_DKC_MMX_6_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   Result := CharPosIEx_DKC_MMX_4(SubStr[1], S, Offset);
  end;
end;

function PosIEx_DKC_MMX_6_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   Result := CharPosIEx_DKC_MMX_4(SubStr[1], S, Offset);
  end;
end;

function PosIEx_DKC_MMX_6_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 SubStrUpper : String;
 UpperChar : Char;

begin
 Result := 0;
 if (Offset <= 0) then
  Exit;
 if S = '' then
  Exit
 else
  StrLength := PInteger(Integer(S)-4)^;
 if SubStr = '' then
  Exit
 else
  SubStrLength := PInteger(Integer(SubStr)-4)^;
 if (SubStrLength <= 0) then
  Exit;
 if (StrLength <= 0) then
  Exit;
 if (Integer(Offset) > StrLength) then
  Exit;
 if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  Exit;
 if SubStrLength > 1 then
  begin
   SubStrUpper := UpperCase_DKC_MMX_33_a(SubStr);
   Result := 0;
   I1 := Offset;
   repeat
    UpperChar := LookUpTable[Ord(S[I1])];
    if SubStrUpper[1] = UpperChar then
     begin
      if I1+SubStrLength -1 > StrLength then
       begin
        Result := 0;
        Exit;
       end;
      I2 := 1;
      repeat
       UpperChar := LookUpTable[Ord(S[I1+I2])];
       if UpperChar <> SubStrUpper[I2+1] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 >= SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  begin
   Result := CharPosIEx_DKC_MMX_4(SubStr[1], S, Offset);
  end;
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/12 2005
//Instruction sets   IA32, MMX

function PosIEx_DKC_MMX_7_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
  push  ebp
  mov   ebp,esp
  sub   esp,24
  push  ebx
  push  esi
  push  edi
  push  ebp
  xor   ebx,ebx
  mov   [esp+$20],ebx
  mov   esi,edx
  mov   edi,eax
  mov   [esp+$1C],ecx
  //if (Offset <= 0) then
  test  ecx,ecx
  jle   @Exit
  //if S = '' then
  test  esi,esi
  jz    @Exit
  //StrLength := PInteger(Integer(S)-4)^;
  mov   eax,[esi-4]
  mov   [esp+$10],eax
  //if (StrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if SubStr = '' then
  test  edi,edi
  jz    @Exit
  //SubStrLength := PInteger(Integer(SubStr)-4)^;
  mov   eax,[edi-4]
  mov   [esp+$14],eax
  //if (SubStrLength <= 0) then
  test  eax,eax
  jle   @Exit
  //if (Integer(Offset) > StrLength) then
  mov   eax,ecx
  mov   edx,[esp+$10]
  cmp   ecx,edx
  jnle  @Exit
  //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
  sub   edx,eax
  inc   edx
  cmp   edx,[esp+$14]
  jl    @Exit
  //SetLength(SubStrUpper, SubStrLength);
  lea   eax,[esp+$20]
  mov   edx,[esp+$14]
  call  System.@LStrSetLength
  //pSubStrUpper := PChar(SubStrUpper);
  mov   eax,[esp+$20]
  //CharNo := 0;
  xor   eax,eax
  mov   ecx,[LookUpTable]
  mov   ebx,[esp+$20]
  mov   ebp,[esp+$14]
@UpperCaseLoopStart :
  //pSubStrUpper[CharNo] := LookUpTable[Ord(SubStr[CharNo+1])];
  movzx edx,[edi+eax]
  movzx edx,[ecx+edx]
  mov   [ebx+eax],dl
  //Inc(CharNo);
  inc   eax
  //until(CharNo >= SubStrLength);
  cmp   eax,ebp
  jl    @UpperCaseLoopStart
  //I1 := Offset;
  mov   eax,[esp+$1C]
  dec   esi
  mov   ebp,[esp+$20]
  mov   ebx,[LookUpTable]
@OuterLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1])];
  movzx edx,[esi+eax]
  movzx ecx,[ebx+edx]
  //if SubStrUpper[1] = UpperChar then
  mov   edx,ebp
  cmp   cl,[edx]
  jnz   @IfEnd1
  //if I1 + SubStrLength - 1 > StrLength then
  mov   edx,[esp+$14]
  add   edx,eax
  dec   edx
  cmp   edx,[esp+$10]
  jnle  @ExitNoMatch
  //if SubStrLength > 1 then
  cmp   dword ptr [esp+$14],1
  jle   @IfEnd2
  //I2 := 1;
  mov   edx,1
@InnerLoopStart :
  //UpperChar := LookUpTable[Ord(S[I1+I2])];
  lea   ecx,[edx+eax]
  movzx ecx,[esi+ecx]
  movzx ecx,[ebx+ecx]
  //if UpperChar <> SubStrUpper[I2+1] then
  cmp   cl,[ebp+edx]
  jnz   @IfEnd1
  //Inc(I2);
  inc   edx
  //if (I2 >= SubStrLength) then
  cmp   edx,[esp+$14]
  jl    @InnerLoopStart
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd2 :
  //Result := I1;
  mov   ebx,eax
  jmp   @Exit
@IfEnd1 :
  //Inc(I1);
  inc   eax
  //until(I1 > StrLength);
  cmp   eax,[esp+$10]
  jle   @OuterLoopStart
@ExitNoMatch :
  xor   ebx,ebx
@Exit :
  lea   eax,[esp+$20]
  call  System.@LStrClr
  mov   eax,ebx
  pop   ebp
  pop   edi
  pop   esi
  pop   ebx
  mov   esp,ebp
  pop   ebp
end;

initialization

  InitializeLookUpTable;
  Filler1;
  Filler2;
  Filler3;
  Filler4;
  Filler5;
  Filler6;
  Filler7;
  Filler8;
  Filler9;
  Filler10;
  Filler11;
  Filler12;
  Filler13;
  Filler14;
  Filler15;
  Filler16;
  Filler17;
  Filler18;
  Filler19;
  Filler20;
  Filler21;
  Filler22;
  Filler23;
  Filler24;
  Filler25;
  Filler26;
  Filler27;
  Filler28;
  Filler29;
  Filler30;
  Filler31;
  Filler32;
  Filler33;
  Filler34;
  Filler35;
  Filler36;
  Filler37;
  Filler38;
  Filler48;
  Filler49;
  Filler50;
  Filler51;
  Filler52;
  Filler53;
  Filler54;
  Filler56;
  Filler57;
  Filler58;
  Filler59;
  Filler60;

end.


