unit PosExDKCUnit;

interface

function PosEx_DKC_Pas_1(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_2(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_3(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_4(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_Pas_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_1(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_2(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_3(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_4(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_5(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_6(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_7(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_8(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_9(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_10(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_11(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_12(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_13(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_14(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_15(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_16(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_17(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_18(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_19(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_20(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_21(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_22(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_23(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_24(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_25(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_26(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_27(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_28(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_29(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_30(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_31(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_32(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_33(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_34(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_35(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_36(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_37(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_38(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_39(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_40(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_41(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_42(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_43(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_44(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_45(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_46(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_47(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_48(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_49(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_50(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_51(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_52(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_53(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_54(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_55(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_56(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_57(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_58(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_59(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_60_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_60_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_60_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_60_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_61_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_61_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_61_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_61_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_62_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_62_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_62_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_62_d(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_63_a(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_63_b(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_63_c(const SubStr, S: string; Offset: Integer = 1): Integer;
function PosEx_DKC_IA32_63_d(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_64a(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_64b(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_64c(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_64d(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_65a(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_65b(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_65c(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_65d(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_66a(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_66b(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_66c(const SubStr, S: string; Offset: Integer = 1): Integer;
//function PosEx_DKC_IA32_66d(const SubStr, S: string; Offset: Integer = 1): Integer;

implementation

//Author:            Dennis Kjaer Christensen
//Date:              7/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_1(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;
 Match : Boolean;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 StrLength := Length(s);
 SubStrLength := Length(SubStr);
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   Result := 0;
   I1 := Offset;
   repeat
    if substr[1] = S[I1] then
     begin
      Match := True;
      if SubStrLength > 1 then
       begin
        I2 := 1;
        repeat
         if (I1+I2 > StrLength) then
          begin
           Match := False;
           Break;
          end;
         if substr[I2+1] <> S[I1+I2] then
          begin
           Match := False;
           Break;
          end;
         Inc(I2);
        until((I2 = SubStrLength));
       end;
      if Match then
       begin
        Result := I1;
        Break;
       end
      else
       begin
        Result := 0;
       end
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              7/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_2(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 StrLength := Length(S);
 SubStrLength := Length(SubStr);
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   Result := 0;
   I1 := Offset;
   repeat
    if SubStr[1] = S[I1] then
     begin
      if SubStrLength = 1 then
       begin
        Result := I1;
        Exit;
       end;
      I2 := 1;
      repeat
       if (I1+I2 > StrLength) then
        begin
         Result := 0;
         Exit;
        end;
       if SubStr[I2+1] <> S[I1+I2] then
        begin
         Break;
        end;
       Inc(I2);
       if (I2 = SubStrLength) then
        begin
         Result := I1;
         Exit;
        end;
      until(False);
     end;
    Inc(I1);
   until(I1 > StrLength);
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              7/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_3(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 StrLength := Length(S);
 SubStrLength := Length(SubStr);
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        I2 := 1;
        repeat
         if (I1+I2 > StrLength) then
          begin
           Result := 0;
           Exit;
          end;
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 = SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              8/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_4(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 StrLength := Length(S);
 SubStrLength := Length(SubStr);
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStr[1] = S[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_5_a(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStr[1] = S[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler1;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_5_b(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStr[1] = S[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler2;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_5_c(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStr[1] = S[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

procedure Filler3;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/3 2005
//Instructionset(s): IA32

function PosEx_DKC_Pas_5_d(const SubStr, S: string; Offset: Integer = 1): Integer;
var
 I1, I2, SubStrLength, StrLength : Integer;

begin
 if (Offset <= 0) then
  begin
   Result := 0;
   Exit;
  end;
 if ((S = '') and (SubStr = '') and (Offset = 1)) then
  begin
   Result := 0;
   Exit;
  end;
 if S <> '' then
  StrLength := PInteger(Integer(S)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if SubStr <> '' then
  SubStrLength := PInteger(Integer(SubStr)-4)^
 else
  begin
   Result := 0;
   Exit;
  end;
 if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
  begin
   if SubStrLength > 1 then
    begin
     Result := 0;
     I1 := Offset;
     if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
      begin
       Result := 0;
       Exit;
      end;
     repeat
      if SubStr[1] = S[I1] then
       begin
        if I1+SubStrLength -1 > StrLength then
         begin
          Result := 0;
          Exit;
         end;
        I2 := 1;
        repeat
         if S[I1+I2] <> SubStr[I2+1] then
          begin
           Break;
          end;
         Inc(I2);
         if (I2 >= SubStrLength) then
          begin
           Result := I1;
           Exit;
          end;
        until(False);
       end;
      Inc(I1);
     until(I1 > StrLength);
    end
   else
    begin
     Result := 0;
     I1 := Offset;
     repeat
      if SubStr[1] = S[I1] then
       begin
        Result := I1;
        Exit;
       end;
      Inc(I1);
     until (I1 > StrLength);
    end;
  end
 else
  Result := 0;
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/3 2005
//Instructionset(s): IA32


function PosEx_DKC_IA32_1(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   add esp,-$08
   mov ebp,ecx
   mov esi,edx
   mov ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   mov [esp],eax
   jmp   @Exit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz @IfEnd2
   test ebx,ebx
   jnz @IfEnd2
   cmp ebp,$01
   jnz @IfEnd2
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   jmp @Exit
 @IfEnd2 :
   //StrLength := Length(S);
   mov eax,esi
   call System.@LStrLen
   mov edi,eax
   //SubStrLength := Length(SubStr);
   mov eax,ebx
   call System.@LStrLen
   mov [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp dword ptr [esp+$04],$00
   jle @Else1
   test edi,edi
   jle @Else1
   cmp edi,ebp
   jl @Else1
   //if SubStrLength > 1 then
   cmp dword ptr [esp+$04],$01
   jle @Else2
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   //I1 := Offset;
   mov eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov edx,edi
   sub edx,ebp
   inc edx
   cmp edx,[esp+$04]
   jnl @IfEnd3
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   jmp @Exit
 @IfEnd3 :
   //repeat
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   mov dl,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov edx,[esp+$04]
   add edx,eax
   dec edx
   cmp edi,edx
   jnl @IfEnd5
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   jmp @Exit
 @IfEnd5 :
   //I2 := 1;
   mov edx,$00000001
   //repeat
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea ecx,[edx+eax]
   mov cl,[esi+ecx-$01]
   cmp cl,[ebx+edx]
   jnz  @Loop2End
   //Break;
 @IfEnd6 :
   //Inc(I2);
   inc edx
   //if (I2 >= SubStrLength) then
   cmp edx,[esp+$04]
   jl @IfEnd7
   //Result := I1;
   mov [esp],eax
   jmp @Exit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   inc eax
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //else
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   //I1 := Offset;
   mov eax,ebp
   //repeat
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   mov dl,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   inc eax
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
 @Exit :
   mov eax,[esp]
   pop ecx
   pop edx
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

function PosEx_DKC_IA32_2(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   //add  esp,-$08
   sub  esp,8
   mov  ebp,ecx
   mov  esi,edx
   mov  ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz  @IfEnd2
   test ebx,ebx
   jnz  @IfEnd2
   //cmp  ebp,$01
   cmp  ebp,1
   jnz  @IfEnd2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd2 :
   //StrLength := Length(S);
   mov  eax,esi
   call System.@LStrLen              //Inline this
   mov  edi,eax
   //SubStrLength := Length(SubStr);
   mov  eax,ebx
   call System.@LStrLen              //Inline this
   mov  [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   //cmp  dword ptr [esp+$04],$00
   cmp  dword ptr [esp+$04],0
   jle  @Else1
   test edi,edi
   jle  @Else1
   cmp  edi,ebp
   jl   @Else1
   //if SubStrLength > 1 then
   //cmp  dword ptr [esp+$04],$01
   cmp  dword ptr [esp+4],1
   jle  @Else2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax
   //I1 := Offset;
   mov  eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov  edx,edi
   sub  edx,ebp
   inc  edx
   //cmp  edx,[esp+$04]
   cmp  edx,[esp+4]
   jnl  @IfEnd3
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   mov  dl,[ebx]                     //Use MOVZX
   cmp  dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz  @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov  edx,[esp+$04]
   add  edx,eax
   dec  edx                          //Use sub edx,1 for P4 Northwood
   cmp  edi,edx
   jnl  @IfEnd5
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd5 :
   //I2 := 1;
   //mov  edx,$00000001
   mov  edx,1
   //repeat
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea  ecx,[edx+eax]
   mov  cl,[esi+ecx-$01]             //Use MOVZX and try to get rid of the -$01
   cmp  cl,[ebx+edx]
   jnz  @Loop2End
 @IfEnd6 :
   //Inc(I2);
   inc  edx                          //Use add edx,1 for P4 Northwood
   //if (I2 >= SubStrLength) then
   cmp edx,[esp+$04]
   jl  @IfEnd7
   //Result := I1;
   mov [esp],eax                     //Remove this line by jumping to NewExit
   jmp @Exit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   inc eax                           //Use add eax,1 for P4 Northwood
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //else
   //Result := 0;
   xor eax,eax
   mov [esp],eax                     //Remove this line by jumping to NewExit
   //I1 := Offset;
   mov eax,ebp
   //repeat
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   //mov dl,[ebx]
   movzx edx,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   //inc eax
   add eax,1
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
 @Exit :
   mov eax,[esp]
 @NewExit :
   pop ecx                           //= add esp,4   no need to restore ecx
   pop edx                           //= add esp,4   no need to restore edx
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

function PosEx_DKC_IA32_3(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   sub  esp,8
   mov  ebp,ecx
   mov  esi,edx
   mov  ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz  @IfEnd2
   test ebx,ebx
   jnz  @IfEnd2
   cmp  ebp,1
   jnz  @IfEnd2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd2 :
   //StrLength := Length(S);
   mov  eax,esi
   call System.@LStrLen              //Inline this
   mov  edi,eax
   //SubStrLength := Length(SubStr);
   mov  eax,ebx
   call System.@LStrLen              //Inline this
   mov  [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp  dword ptr [esp+$04],0
   jle  @Else1
   test edi,edi
   jle  @Else1
   cmp  edi,ebp
   jl   @Else1
   //if SubStrLength > 1 then
   cmp  dword ptr [esp+4],1
   jle  @Else2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax
   //I1 := Offset;
   mov  eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov  edx,edi
   sub  edx,ebp
   inc  edx
   cmp  edx,[esp+4]
   jnl  @IfEnd3
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   mov  dl,[ebx]                     //Use MOVZX
   cmp  dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz  @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov  edx,[esp+$04]
   add  edx,eax
   dec  edx                          //Use sub edx,1 for P4 Northwood
   cmp  edi,edx
   jnl  @IfEnd5
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd5 :
   //I2 := 1;
   //mov  edx,$00000001
   mov  edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea  ecx,[edx+eax]
   //mov  cl,[esi+ecx-$01]             //Use MOVZX and try to get rid of the -$01
   movzx ecx,[esi+ecx-$01]
   cmp  cl,[ebx+edx]
   jnz  @Loop2End
 @IfEnd6 :
   //Inc(I2);
   //inc  edx                          //Use add edx,1 for P4 Northwood
   add edx,1
   //if (I2 >= SubStrLength) then
   //cmp edx,[esp+$04]
   cmp edx,[esp+4]
   jl  @IfEnd7
   //Result := I1;
   mov [esp],eax                     //Remove this line by jumping to NewExit
   jmp @Exit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   //inc eax                           //Use add eax,1 for P4 Northwood
   add  eax,1
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax                     //Remove this line by jumping to NewExit
   //I1 := Offset;
   mov eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   add eax,1
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
 @Exit :
   mov eax,[esp]
 @NewExit :
   pop ecx                           //= add esp,4   no need to restore ecx
   pop edx                           //= add esp,4   no need to restore edx
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

function PosEx_DKC_IA32_4(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   sub  esp,8
   mov  ebp,ecx
   mov  esi,edx
   mov  ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz  @IfEnd2
   test ebx,ebx
   jnz  @IfEnd2
   cmp  ebp,1
   jnz  @IfEnd2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd2 :
   //StrLength := Length(S);
   mov  eax,esi
   call System.@LStrLen              //Inline this
   mov  edi,eax
   //SubStrLength := Length(SubStr);
   mov  eax,ebx
   call System.@LStrLen              //Inline this
   mov  [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   //cmp  dword ptr [esp+$04],0
   cmp  dword ptr [esp+4],0
   jle  @Else1
   test edi,edi
   jle  @Else1
   cmp  edi,ebp
   jl   @Else1
   //if SubStrLength > 1 then
   cmp  dword ptr [esp+4],1
   jle  @Else2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax
   //I1 := Offset;
   mov  eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov  edx,edi
   sub  edx,ebp
   inc  edx
   cmp  edx,[esp+4]
   jnl  @IfEnd3
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   mov  dl,[ebx]                     //Use MOVZX
   cmp  dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz  @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   //mov  edx,[esp+$04]
   mov  edx,[esp+4]
   add  edx,eax
   //dec  edx                          //Use sub edx,1 for P4 Northwood
   sub  edx,1
   cmp  edi,edx
   jnl  @IfEnd5
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd5 :
   //I2 := 1;
   mov  edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea  ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]
   cmp  cl,[ebx+edx]
   jnz  @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add edx,1
   //if (I2 >= SubStrLength) then
   cmp edx,[esp+4]
   jl  @IfEnd7
   //Result := I1;
   mov [esp],eax                     //Remove this line by jumping to NewExit
   jmp @Exit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add  eax,1
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax                     //Remove this line by jumping to NewExit
   //I1 := Offset;
   mov eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   add eax,1
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
 @Exit :
   mov eax,[esp]
 @NewExit :
   pop ecx                           //= add esp,4   no need to restore ecx
   pop edx                           //= add esp,4   no need to restore edx
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              13/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_5(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   sub  esp,8
   mov  ebp,ecx
   mov  esi,edx
   mov  ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz  @IfEnd2
   test ebx,ebx
   jnz  @IfEnd2
   cmp  ebp,1
   jnz  @IfEnd2
   //Result := 0;
   xor  eax,eax
   //mov  [esp],eax                    //Remove this by jumping to NewExit
   jmp  @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov  eax,esi
   call System.@LStrLen              //Inline this
   mov  edi,eax
   //SubStrLength := Length(SubStr);
   mov  eax,ebx
   call System.@LStrLen              //Inline this
   mov  [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp  dword ptr [esp+4],0
   jle  @Else1
   test edi,edi
   jle  @Else1
   cmp  edi,ebp
   jl   @Else1
   //if SubStrLength > 1 then
   cmp  dword ptr [esp+4],1
   jle  @Else2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                      //Remove this by jumping to NewExit
   //I1 := Offset;
   mov  eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov  edx,edi
   sub  edx,ebp
   inc  edx                            //Use add edx,1 for P4 Northwood
   cmp  edx,[esp+4]
   jnl  @IfEnd3
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                      //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   //mov  dl,[ebx]                     //Use MOVZX
   movzx edx,[ebx]
   cmp  dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz  @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   //mov  edx,[esp+$04]
   mov  edx,[esp+4]
   add  edx,eax
   sub  edx,1
   cmp  edi,edx
   jnl  @IfEnd5
   //Result := 0;
   xor  eax,eax
   //mov  [esp],eax                    //Remove this by jumping to NewExit
   //jmp  @Exit
   jmp  @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov  edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea  ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]             //Try to get rid of the -$01
   cmp  cl,[ebx+edx]
   jnz  @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add edx,1
   //if (I2 >= SubStrLength) then
   cmp edx,[esp+4]
   jl  @IfEnd7
   //Result := I1;
   //mov [esp],eax                     //Remove this line by jumping to NewExit
   //jmp @Exit
   jmp @NewExit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add  eax,1
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   //I1 := Offset;
   mov eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax                     //Remove this line by jumping to NewExit
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   add eax,1
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax                     //Remove this line by jumping to NewExit
 @Exit :
   mov eax,[esp]
 @NewExit :
   //pop ecx                           //= add esp,4   no need to restore ecx
   //pop edx                           //= add esp,4   no need to restore edx
   add esp,8
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              13/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_6(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push ebx
   push esi
   push edi
   push ebp
   sub  esp,8
   mov  ebp,ecx
   mov  esi,edx
   mov  ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test esi,esi
   jnz  @IfEnd2
   test ebx,ebx
   jnz  @IfEnd2
   cmp  ebp,1
   jnz  @IfEnd2
   //Result := 0;
   xor  eax,eax
   jmp  @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov  eax,esi
   call System.@LStrLen              //Inline this
   mov  edi,eax
   //SubStrLength := Length(SubStr);
   mov  eax,ebx
   call System.@LStrLen              //Inline this
   mov  [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp  dword ptr [esp+4],0
   jle  @Else1
   test edi,edi
   jle  @Else1
   cmp  edi,ebp
   jl   @Else1
   //if SubStrLength > 1 then
   cmp  dword ptr [esp+4],1
   jle  @Else2
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                      //Remove this by jumping to NewExit
   //I1 := Offset;
   mov  eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov  edx,edi
   sub  edx,ebp
   inc  edx                            //Use add edx,1 for P4 Northwood
   cmp  edx,[esp+4]
   jnl  @IfEnd3
   //Result := 0;
   xor  eax,eax
   mov  [esp],eax                      //Remove this by jumping to NewExit
   jmp  @Exit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp  dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz  @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov  edx,[esp+4]
   add  edx,eax
   sub  edx,1
   cmp  edi,edx
   jnl  @IfEnd5
   //Result := 0;
   xor  eax,eax
   jmp  @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov  edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea  ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]             //Try to get rid of the -$01
   cmp  cl,[ebx+edx]
   jnz  @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add edx,1
   //if (I2 >= SubStrLength) then
   cmp edx,[esp+4]
   jl  @IfEnd7
   //Result := I1;
   jmp @NewExit
 @IfEnd7 :
   //until(False);
   jmp @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add  eax,1
   //until(I1 > StrLength);
   cmp edi,eax
   jnl @Loop1Start
   jmp @Exit
 @Else2 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax
   //I1 := Offset;
   mov eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp dl,[esi+eax-$01]
   jnz @IfEnd8
   //Result := I1;
   mov [esp],eax                     //Remove this line by jumping to NewExit
   jmp @Exit
 @IfEnd8 :
   //Inc(I1);
   add eax,1
   //until (I1 > StrLength);
   cmp edi,eax
   jnl @Loop3Start
   jmp @Exit
 @Else1 :
   //Result := 0;
   xor eax,eax
   mov [esp],eax                     //Remove this line by jumping to NewExit
 @Exit :
   mov eax,[esp]
 @NewExit :
   add esp,8
   pop ebp
   pop edi
   pop esi
   pop ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              13/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_7(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi
   call  System.@LStrLen              //Inline this
   mov   edi,eax
   //SubStrLength := Length(SubStr);
   mov   eax,ebx
   call  System.@LStrLen              //Inline this
   mov   [esp+$04],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   //inc   edx                            //Use add edx,1 for P4 Northwood
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   //mov  [esp],eax                      //Remove this by jumping to NewExit
   //jmp  @Exit
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]             //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   //mov   [esp],eax                     //Remove this line by jumping to NewExit
   //jmp   @Exit
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                     //Remove this line by jumping to NewExit
 @Exit :
   mov   eax,[esp]
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              15/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_8(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                        //Remove this by Copy Propagation and dead code removal
   //call  System.@LStrLen              //Inline this
   test  eax,eax
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                        //Remove this by changing the prior line
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                        //Remove this by Copy Propagation and dead code removal
   //call  System.@LStrLen              //Inline this
   test  eax,eax
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+$04],eax                  //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   //inc   edx                            //Use add edx,1 for P4 Northwood
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]             //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]             //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                     //Remove this line by jumping to NewExit
 @Exit :
   mov   eax,[esp]
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_9(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   //test  eax,eax
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   //test  eax,eax
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   //mov   [esp+$04],eax             //Remove this by changing the prior line
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   //inc   edx                       //Use add edx,1 for P4 Northwood
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Remove this line by jumping to NewExit
 @Exit :
   mov   eax,[esp]
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_10(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ebp,ebp
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?  Yes at jump to @Exit
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   //mov   [esp],eax                 //Remove this line by jumping to NewExit
   jmp   @NewExit
 @Exit :
   mov   eax,[esp]                   //Only place that Result at [esp] is used
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_11(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   //test  ebp,ebp                   //Partial copy propagation off  mov   ebp,ecx
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :                         //One label can be removed
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   //Insert this line mov   eax,[esp] and it is safe to jump to NewExit
   jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?  Yes at jump to @Exit. Is eax preserve along that code path? No
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   //Insert this line mov   eax,[esp] and it is safe to jump to NewExit
   jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit                    //Bad idea to have this jump.
 @Exit :
   mov   eax,[esp]                   //Only place that Result at [esp] is used
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_12(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :                         //One label can be removed
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   //Insert this line
   mov   eax,[esp] //and it is safe to jump to NewExit
   jmp   @NewExit
   //jmp   @Exit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?  Yes at jump to @Exit. Is eax preserve along that code path? No
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   //Insert this line
   mov   eax,[esp]
   //and it is safe to jump to NewExit
   jmp   @NewExit
   //jmp   @Exit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit                    //Bad idea to have this jump.
 @Exit :
   mov   eax,[esp]                   //Place breakpoint and verify that this line is never used//Only place that Result at [esp] is used
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_13(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @IfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2End
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2End :                         //One label can be removed
 @IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?  Yes at jump to @Exit. Is eax preserve along that code path? No
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit                    //Bad idea to have this jump.
 @Exit :
   //mov   eax,[esp]                   //Newer used - remove//Place breakpoint and verify that this line is never used//Only place that Result at [esp] is used
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_14(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3 :
 @Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :                   //One label can be removed
 //@IfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used?
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_15(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //Next 3 lines can be moved forward**********
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //To here ***********************************
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
 //@IfEnd3 :
 //@Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx-$01]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax-$01]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              16/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_16(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //Next 3 lines can be moved forward**********
   //mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   //mov   esi,edx
   //mov   ebx,eax
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //To here ***********************************
   mov   ebp,ecx                     //Remove this by Copy Propagation and dead code removal
   mov   esi,edx
   mov   ebx,eax

   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  esi,esi
   jnz   @IfEnd2
   test  ebx,ebx
   jnz   @IfEnd2
   cmp   ebp,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_17(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   //test  esi,esi                   //Copy propagation
   test  edx,edx
   jnz   @IfEnd2
   //test  ebx,ebx                   //Copy propagation
   test  eax,eax
   jnz   @IfEnd2
   //cmp   ebp,1                     //Copy propagation
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @LStrLenExit1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @LStrLenExit2
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_18(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   mov   eax,esi                     //Remove this by Copy Propagation and dead code removal
   test  esi,esi
   //jz    @LStrLenExit1               //Jump directly out with Result := 0 if pointer is nil = jmp @Else1 :
   jz    @Else1
   mov   eax,[eax-4]
 @LStrLenExit1 :
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   //jz    @LStrLenExit2               //Jump directly out with Result := 0 if pointer is nil = jmp @Else1 :
   jz    @Else1
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_19(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   //mov   eax,esi                     //only used if pointer <> nil//Remove this by Copy Propagation and dead code removal
   test  esi,esi
   jz    @Else1
   mov   eax,esi                       //Then it is safe to move it around the jump
   mov   eax,[eax-4]
 @LStrLenExit1 :
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   mov   eax,ebx                     //Remove this by Copy Propagation and dead code removal
   test  ebx,ebx
   jz    @Else1
   mov   eax,[eax-4]
 @LStrLenExit2 :
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_20(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   //mov   eax,esi                       //Then it is safe to move it around the jump
   //mov   eax,[eax-4]               //Now it is obvious that the copy in eax is only used here
   mov   eax,[esi-4]
 @LStrLenExit1 :                     //This label is not used anymore
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   //mov   eax,ebx                     //Move it around the next two lines *******
   test  ebx,ebx
   jz    @Else1
   mov   eax,ebx                     //and place it here ********
   mov   eax,[eax-4]
 @LStrLenExit2 :                     //This label is not used anymore
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_21(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   mov   eax,[esi-4]
 @LStrLenExit1 :                     //This label is not used anymore
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,ebx
   //mov   eax,[eax-4]                 //Copy propagate
   mov   eax,[ebx-4]
 //@LStrLenExit2 :                     //This label is not used anymore
   mov   [esp+4],eax                 //Remove this by changing the prior line
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   cmp   dword ptr [esp+4],0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_22(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   mov   esi,edx                     //Remove this line by Copy Propagation and dead code removal
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   mov   eax,[esi-4]
 @LStrLenExit1 :                     //This label is not used anymore
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   //mov   eax,ebx                     //Dead code removal
   mov   eax,[ebx-4]
   mov   [esp+4],eax                 //Remove this by changing the prior line? No mem to mem instructions are not part of IA32
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   //cmp   dword ptr [esp+4],0         //Use the copy in eax
   cmp   eax,0
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_23(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   //mov   esi,edx                     //This line is only needed after @IfEnd2 : *********
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   esi,edx                     //So place it there **********
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   mov   eax,[esi-4]
 @LStrLenExit1 :                     //This label is not used anymore
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,[ebx-4]
   mov   [esp+4],eax                 //Remove this by changing the prior line? No mem to mem instructions are not part of IA32
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   //cmp   eax,0                       // Use test eax,eax = peephole optimization
   test  eax,eax
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]            //Try to get rid of the -$01  //The -$01 is always used together with esi. decrementing esi before any use will remove all instances of -$01
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_24(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //Move around @IfEnd2 :*****
   //mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   //mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //***************
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   mov   eax,[esi-4]
 //@LStrLenExit1 :                     //This label is not used anymore
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]           //Try to get rid of the -$01
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_25(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   test  esi,esi
   jz    @Else1
   mov   eax,[esi-4]
   sub   esi,1
   mov   edi,eax                     //Remove this by changing the prior line, but also taking care of the other code path via jz @LStrLenExit1 (if pointer in esi/eax is nil)
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_26(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   //test  esi,esi                     //Copy propagate
   test  edx,edx                     //and use copy in edx
   jz    @Else1
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_27(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   test  edx,edx
   jz    @Else1
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @Else1
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @Else1
   test  edi,edi
   jle   @Else1
   cmp   edi,ebp
   jl    @Else1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else1 :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_28(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   test  edx,edx
   //jz    @Else1
   jz    @ExitResultZero
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   //jz    @Else1
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   //jle   @Else1
   jle   @ExitResultZero
   test  edi,edi
   //jle   @Else1
   jle   @ExitResultZero
   cmp   edi,ebp
   //jl    @Else1
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then //No room for match
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax                   //Is the Result at [esp] ever used? Yes can be changed on the way. Then the line is needed
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 //@Else1 :
 @ExitResultZero :                   //A better name
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              17/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_29(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   mov   esi,edx
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jnl   @IfEnd5
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_30(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jnle  @IfEnd1                     //Try making the most used path without jumping - improve branch prediction
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   mov   ebx,eax                     //Remove this line by Copy Propagation and dead code removal
   //mov   esi,edx                     //Move forward to places were esi are used. ****
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero             //Can move to here because esi it not used at @ExitResultZero *****
   mov   esi,edx
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jnl   @IfEnd3Loop1Start           //Remove the jump from the most used codepath by jumping out on the inverse condition
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   //jnl   @IfEnd5                     //Convert this jump too
   jl    @ExitResultZero               //Invert jump condition not low -> low 
   //Result := 0;
   //xor   eax,eax                     //Remove
   //jmp   @NewExit                    //Remove
 @IfEnd5 :
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_31(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   //jnle  @IfEnd1                     //Try making the most used path without jumping - improve branch prediction
   jle   @ExitResultZero
   //Result := 0;
   //xor   eax,eax
   //jmp   @NewExit
 //@IfEnd1 :
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   //mov   ebx,eax                   //Move forward**** //Remove this line by Copy Propagation and dead code removal
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero             //Take a rest here***** :-)
   mov   ebx,eax
   mov   esi,edx
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   //jnl   @IfEnd3Loop1Start         //Remove the jump from the most used codepath by jumping out on the inverse condition
   jl    @ExitResultZero
   //Result := 0;
   //xor   eax,eax                   //Removed
   //jmp   @NewExit                  //Removed
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
 //@IfEnd5 :                         //Not used anymore
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_32(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jnz   @IfEnd2                     //Remove this jump too
   //Result := 0;
   xor   eax,eax
   jmp   @NewExit
 @IfEnd2 :
   mov   ebp,ecx                     //Remove this line by Copy Propagation and dead code removal
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   ebx,eax                     //Move forward to a point were eax is changed or ebx is used
   mov   esi,edx
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_33(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   //jnz   @IfEnd2                     //Remove this jump too
   jz    @ExitResultZero
   //Result := 0;
   //xor   eax,eax
   //jmp   @NewExit
 @IfEnd2 :
   //mov   ebp,ecx                     //Move forward *****
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   ebx,eax                     //Move forward to a point were eax is changed or ebx is used
   mov   esi,edx
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx                     //To here because ebp is used here**********
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_34(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   //mov   ebx,eax                     //Move forward to a point were eax is changed or ebx is used ******
   mov   esi,edx
   mov   ebx,eax                     //Eax is changed here ****
   mov   eax,[esi-4]
   mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ebp
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_35(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   mov   ebx,eax
   //mov   eax,[esi-4]
   mov   edi,[esi-4]
   //mov   edi,eax                     //Remove this by changing the prior line = rewerse copy propagation , if copy in eax is not used later
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ebp                     //Use copy in ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7                     //Two jumps after each other can be cleaned up
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_36(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   //mov   ebx,eax                   //Remove forward ****
   mov   edi,[esi-4]                 //Use copy in edx
   sub   esi,1
   //SubStrLength := Length(SubStr);
   mov   ebx,eax                     //To first use of ebx ***
   test  ebx,ebx
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ebp                     //Use copy in ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @IfEnd7                     //Two jumps after each other can be cleaned up
   //Result := I1;
   jmp   @NewExit
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_37(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   //mov   edi,[esi-4]                 //Use copy in edx
   mov   edi,[edx-4]                 //Use copy in edx
   sub   esi,1
   //SubStrLength := Length(SubStr);
   mov   ebx,eax
   test  ebx,ebx                    //Use copy in eax
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ebp                     //Use copy in ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax                    //eax is used as temp in these two lines only - try to free it up
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   //jl    @IfEnd7                   //Two jumps after each other can be cleaned up
   jnl   @NewExit                    //Invert condition and jump to @NewExit
   //Result := I1;
   //jmp   @NewExit                  //Remove
 @IfEnd7 :
   //until(False);
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_38(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   mov   edi,[edx-4]
   sub   esi,1
   //SubStrLength := Length(SubStr);
   mov   ebx,eax
   //test  ebx,ebx                    //Use copy in eax
   test  eax,eax
   jz    @ExitResultZero
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ebp                     //Use copy in ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax                    //eax is used as temp in these two lines only - try to free it up
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jnl   @NewExit                    //Invert condition and jump to @NewExit
 //@IfEnd7 :
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_39(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   mov   edi,[edx-4]
   sub   esi,1
   //SubStrLength := Length(SubStr);
   mov   ebx,eax                     //Move forward ***
   test  eax,eax
   jz    @ExitResultZero
   mov   eax,[ebx-4]                 //To here*****
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   //cmp   edi,ebp                   //Use copy in ecx
   cmp   edi,ecx                     //Using copy in ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax                     //eax is used as temp in these two lines only - try to free it up
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jnl   @NewExit                    //Invert condition and jump @Loop2Start
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :                            //CharPosEx
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   //Result := 0;
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              18/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_40(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   mov   edi,[edx-4]
   sub   esi,1
   //SubStrLength := Length(SubStr);
   //mov   ebx,eax                   //Move forward ***
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax                     //To here*****
   mov   eax,[ebx-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax                     //eax is used as temp in these two lines only - try to free it up
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jnl   @NewExit                    //Invert condition and jump @Loop2Start
   jmp   @Loop2Start
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :                            //CharPosEx
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              19/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_41(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   esi,edx
   mov   edi,[edx-4]
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   //mov   eax,[ebx-4]
   mov   eax,[eax-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   xor   eax,eax                     //eax is used as temp in these two lines only - try to free it up
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 @IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   //jnl   @NewExit                  //Invert condition and jump @Loop2Start
   jl    @Loop2Start
   //jmp   @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :                            //CharPosEx
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   mov   eax,[esp]
   jmp   @NewExit
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              19/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_42(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   //mov   esi,edx
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used?
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]
   mov   [esp+4],eax
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @Else2
   //Result := 0;
   //xor   eax,eax                     //eax is used as temp in these two lines only - try to free it up
   //mov   [esp],eax
   mov   [esp],0
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
 //@IfEnd6 :
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]
   jmp   @NewExit
 @Else2 :                            //CharPosEx
   //Result := 0;
   xor   eax,eax
   mov   [esp],eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   //mov   eax,[esp]                   //[esp] always zero? Yes
   xor   eax,eax
   jmp   @NewExit
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              19/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_43(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //Result := 0;
   mov   [esp],0
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   mov   eax,[esp]                       //[esp] always zero?
   jmp   @NewExit
 @CharPosEx :                            //CharPosEx
   //Result := 0;
   xor   eax,eax
   //mov   [esp],eax                 //[esp] Not used anymore
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   xor   eax,eax
   //jmp   @NewExit                    //Not needed
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              19/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_44(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //Result := 0;
   mov   [esp],0
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   //mov   eax,[esp]                       //[esp] always zero? Yes
   xor   eax,eax
   jmp   @NewExit
 @CharPosEx :
   //Result := 0;
   xor   eax,eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
   //xor   eax,eax
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_45(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //Result := 0;
   mov   [esp],0                     //Remove and change reload to xor xxx,xxx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   xor   eax,eax                     //Remove
   jmp   @NewExit                    //And jump to @ExitResultZero
 @CharPosEx :
   //Result := 0;
   xor   eax,eax
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_46(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //Result := 0;
   //mov   [esp],0                     //Remove and change reload to xor xxx,xxx No reload found
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   //xor   eax,eax                     //Remove
   //jmp   @NewExit                    //And jump to @ExitResultZero
   jmp   @ExitResultZero
 @CharPosEx :
   //Result := 0;
   //xor   eax,eax                     //Overwritten in next line
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_47(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   eax,ebp
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_48(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   movzx edx,[ebx]                   //Loop invariant. Moved out before loop if a register can be found to hold the search char
   cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   eax,ebp
   movzx edx,[ebx]
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   //movzx edx,[ebx]                   //Loop invariant
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_49(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   mov   esi,edx                     //Is copy in edx ever used? No
   sub   esi,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   //mov   ,[ebx]                    //Register needed, eax, ebx, ecx, edx, esi, edi are used. ebp is free but has no byte access instructions
   mov   cl,[ebx]                    //but ecx is only used as temp in the innerloop and can be restored when exiting it
 @IfEnd3Loop1Start :
   //if SubStr[1] = S[I1] then
   //movzx edx,[ebx]                   //Loop invariant. Moved out before loop if a register can be found to hold the search char
   //cmp   dl,[esi+eax]                //Try make implicit memory load explicit
   cmp   cl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @Loop2Start :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   //jnz   @Loop2EndIfEnd4
   jnz   @Loop2EndIfEnd4RestoreEcx    //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @Loop2Start
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @IfEnd3Loop1Start
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   eax,ebp
   movzx edx,[ebx]
 @Loop3Start :
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @Loop3Start
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_50(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   //mov   esi,edx                     //Is copy in edx ever used? No Then copy propagate Move this one forward *****
   //sub   esi,1
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx                  //This creates to code paths were mov   esi,edx has to be moved to ********
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx                     //To here *************
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 //@IfEnd3Loop1Start :
 @OuterLoopStart :                   //Better name
   //if SubStr[1] = S[I1] then
   cmp   cl,[esi+eax]                //Try make implicit memory load explicit
   jnz   @Loop2EndIfEnd4
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 //@Loop2Start :
 @InnerLoopStart :                   //Better name
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx    //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx                     //To here also **********************
   mov   eax,ebp
   movzx edx,[ebx]
 //@Loop3Start :
 @CharPosExLoop :                    //Better name
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_51(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   //cmp   cl,[esi+eax]                //Try make implicit memory load explicit
   mov   ch,[esi+eax]                  //This upens up the possibility of using movzx
   cmp   cl,ch
   jnz   @Loop2EndIfEnd4               //Jump taken most of the time. Can give decoder stalls on CPU's without trace caches. Try to remove it
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx    //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]
   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_52(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi used?
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   mov   ch,[esi+eax]                  //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,ch
   jnz   @Loop2EndIfEnd4               //Jump taken most of the time. Can give decoder stalls on CPU's without trace caches. Try to remove it
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx    //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]
{   jnz   @IfEnd8
   //Result := I1;
   jmp   @NewExit
 @IfEnd8 :}
   jz    @NewExit
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_53(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   mov   ch,[esi+eax]                //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,ch
   jnz   @Loop2EndIfEnd4             //Jump taken most of the time. Can give decoder stalls on CPU's without trace caches. Try to remove it
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1                       //Move SubStrLength -1 out of loop
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :                   //Try separating innerloop from outerloop to remove taken branches on repeated searching from the outerloop
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]               //lea used as add
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]                //Try making it pointer based
   jz    @NewExit
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              20/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_54(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   mov   ch,[esi+eax]                //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,ch
   jnz   @Loop2EndIfEnd4             //Jump taken most of the time. Can give decoder stalls on CPU's without trace caches. Try to remove it
   //***************InnerLoop starts here **************************
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :                   //Try separating innerloop from outerloop to remove taken branches on repeated searching from the outerloop
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]               //lea used as add
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   //***************InnerLoop ends here **************************
 @Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :                    //Try unrolling loop
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]                //Try making it pointer based
   jz    @NewExit
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_55(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   mov   ch,[esi+eax]                //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,ch
   //jnz   @Loop2EndIfEnd4             //Jump taken most of the time. Can give decoder stalls on CPU's without trace caches. Try to remove it
   jz    @InnerLoop
 @OuterLoopReentry :
 //@Loop2EndIfEnd4 :
   //Inc(I1);
   add   eax,1
   //until(I1 > StrLength);
   cmp   edi,eax
   jnl   @OuterLoopStart
   jmp   @ExitResultZero

   //***************InnerLoop starts here **************************
 @InnerLoop :
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,eax
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :                   //Try separating innerloop from outerloop to remove taken branches on repeated searching from the outerloop
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+eax]               //lea used as add
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
   //***************InnerLoop ends here **************************

 @CharPosEx :
   //I1 := Offset;
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :                    //Try unrolling loop
   //if SubStr[1] = S[I1] then
   cmp   dl,[esi+eax]                //Try making it pointer based
   jz    @NewExit
   //Inc(I1);
   add   eax,1
   //until (I1 > StrLength);
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_56(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   sub   edx,1
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   ebp,eax
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]                //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   //Inc(I1);
   add   ebp,1
   //until(I1 > StrLength);
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,ebp
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   //I2 := 1;
   mov   edx,1
 @InnerLoopStart :
   //if S[I1+I2] <> SubStr[I2+1] then
   lea   ecx,[edx+ebp]               //lea used as add
   movzx ecx,[esi+ecx]
   cmp   cl,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   //Inc(I2);
   add   edx,1
   //if (I2 >= SubStrLength) then
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   cmp   dl,[esi+eax]
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_57(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   ebp,eax
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]                //This upens up the possibility of using movzx if a free register can be found
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   //if I1+SubStrLength -1 > StrLength then
   mov   edx,[esp+4]
   add   edx,ebp
   sub   edx,1
   cmp   edi,edx
   jl    @ExitResultZero
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   cmp   dl,[esi+eax]
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_58(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1         //eax still good
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero
   mov   ebp,eax
   sub   edi,[esp+4]
   add   edi,1
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   cmp   dl,[esi+eax]
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_59(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   //if ((S = '') and (SubStr = '') and (Offset = 1)) then
   test  edx,edx
   jnz   @IfEnd2
   test  eax,eax
   jnz   @IfEnd2
   cmp   ecx,1
   jz    @ExitResultZero
 @IfEnd2 :
   //StrLength := Length(S);
   test  edx,edx
   jz    @ExitResultZero
   mov   edi,[edx-4]
   //SubStrLength := Length(SubStr);
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,eax
   mov   eax,[eax-4]                 //
   mov   [esp+4],eax                 // [esp+4] = [eax-4] Can be accessed equally fast, but eax is needed
   //if ((SubStrLength > 0) and (StrLength > 0) and (Integer(Offset) <= StrLength))then
   test  eax,eax
   jle   @ExitResultZero
   test  edi,edi
   jle   @ExitResultZero
   mov   ebp,ecx
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   dword ptr [esp+4],1         //eax still good
   jle   @CharPosEx
   //I1 := Offset;
   mov   eax,ebp
   //if (StrLength - Integer(Offset) + 1 < SubStrLength) then
   mov   esi,edx
   mov   edx,edi                     //Redundant?  Is the copy in edi ever used? Yes
   {sub   edx,ebp
   add   edx,1
   cmp   edx,[esp+4]
   jl    @ExitResultZero}
   mov   ebp,eax
   sub   edi,[esp+4]
   add   edi,1
   //if (StrLength - SubStrLength  + 1 < Integer(Offset)) then
   cmp   edi,ebp
   jl    @ExitResultZero
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   eax,ebp
   movzx edx,[ebx]
 @CharPosExLoop :
   cmp   dl,[esi+eax]
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_60_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_60_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_60_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_60_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   cl,[ebx]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx eax,[esi+ebp]
   cmp   cl,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx eax,[ecx+edx]
   cmp   al,[ebx+edx]
   jnz   @Loop2EndIfEnd4RestoreEcx   //Restore ecx before reentering OuterLoop
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4RestoreEcx :
   mov   cl,[ebx]
   jmp   @OuterLoopReentry
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_61_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_61_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_61_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              23/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_61_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_62_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
   add   edi,esi                     //point at end of string
   mov   eax,esi
   add   esi,ecx                     //point at offset in string
 @CharPosExLoop :
   movzx ecx,[esi]
   cmp   dl,cl
   jz    @CharPosExExit
   add   esi,1
   cmp   edi,esi
   jnl   @CharPosExLoop
   jmp   @ExitResultZero
 @CharPosExExit :
   xchg  eax,esi
   sub   eax,esi
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

procedure Filler4;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_62_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
   add   edi,esi                     //point at end of string
   mov   eax,esi
   add   esi,ecx                     //point at offset in string
 @CharPosExLoop :
   movzx ecx,[esi]
   cmp   dl,cl
   jz    @CharPosExExit
   add   esi,1
   cmp   edi,esi
   jnl   @CharPosExLoop
   jmp   @ExitResultZero
 @CharPosExExit :
   xchg  eax,esi
   sub   eax,esi
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

procedure Filler5;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_62_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
   add   edi,esi                     //point at end of string
   mov   eax,esi
   add   esi,ecx                     //point at offset in string
 @CharPosExLoop :
   movzx ecx,[esi]
   cmp   dl,cl
   jz    @CharPosExExit
   add   esi,1
   cmp   edi,esi
   jnl   @CharPosExLoop
   jmp   @ExitResultZero
 @CharPosExExit :
   xchg  eax,esi
   sub   eax,esi
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

procedure Filler6;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              28/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_62_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,12
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   sub   edx,1
   mov   esi,edx
   mov   edx,edi
   sub   edi,ebx
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   mov   [esp+4],ebx
   movzx ecx,[eax]
 @OuterLoopStart :
   //if SubStr[1] = S[I1] then
   movzx ebx,[esi+ebp]
   cmp   cl,bl
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ebp,1
   cmp   edi,ebp
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   [esp+8],edi
   mov   edi,[esp+4]
   lea   ecx,[esi+ebp]               //Pointer into S
   mov   edx,1
 @InnerLoopStart :
   movzx ebx,[ecx+edx]
   cmp   bl,[eax+edx]
   jnz   @Loop2EndIfEnd4Restore
   add   edx,1
   cmp   edx,edi
   jl    @InnerLoopStart
   mov   eax,ebp
   jmp   @NewExit
 @Loop2EndIfEnd4Restore :
   movzx ecx,[eax]
   mov   edi,[esp+8]
   jmp   @OuterLoopReentry
 @CharPosEx :
   sub   edx,1
   mov   esi,edx
   movzx edx,[eax]
   mov   eax,ecx
   add   edi,esi                     //point at end of string
   mov   eax,esi
   add   esi,ecx                     //point at offset in string
 @CharPosExLoop :
   movzx ecx,[esi]
   cmp   dl,cl
   jz    @CharPosExExit
   add   esi,1
   cmp   edi,esi
   jnl   @CharPosExLoop
   jmp   @ExitResultZero
 @CharPosExExit :
   xchg  eax,esi
   sub   eax,esi
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,12
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_63_a(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   lea   ecx,[esi+ebp]               //Pointer into S at Offset
   add   edi,esi                     //Points at end of S
   mov   ah,[ebx]                    //First char in SubStr
 @OuterLoopStart :
   mov   al,[ecx]
   cmp   ah,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ecx,1
   cmp   edi,ecx
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   edx,1
 @InnerLoopStart :
   mov   al,[ecx+edx]                //Load next char from S
   cmp   al,[ebx+edx]                //Compare to next char in SubStr
   jnz   @OuterLoopReentry
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ecx
   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
   jmp   @NewExit
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_63_b(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   lea   ecx,[esi+ebp]               //Pointer into S at Offset
   add   edi,esi                     //Points at end of S
   mov   ah,[ebx]                    //First char in SubStr
 @OuterLoopStart :
   mov   al,[ecx]
   cmp   ah,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ecx,1
   cmp   edi,ecx
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   edx,1
 @InnerLoopStart :
   mov   al,[ecx+edx]                //Load next char from S
   cmp   al,[ebx+edx]                //Compare to next char in SubStr
   jnz   @OuterLoopReentry
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ecx
   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
   jmp   @NewExit
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_63_c(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   lea   ecx,[esi+ebp]               //Pointer into S at Offset
   add   edi,esi                     //Points at end of S
   mov   ah,[ebx]                    //First char in SubStr
 @OuterLoopStart :
   mov   al,[ecx]
   cmp   ah,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ecx,1
   cmp   edi,ecx
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   edx,1
 @InnerLoopStart :
   mov   al,[ecx+edx]                //Load next char from S
   cmp   al,[ebx+edx]                //Compare to next char in SubStr
   jnz   @OuterLoopReentry
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ecx
   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
   jmp   @NewExit
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

//Author:            Dennis Kjaer Christensen
//Date:              29/3 2005
//Instructionset(s): IA32

function PosEx_DKC_IA32_63_d(const SubStr, S: string; Offset: Integer = 1): Integer;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   sub   esp,8
   //if (Offset <= 0) then
   test  ecx,ecx
   jle   @ExitResultZero
   test  edx,edx
   jz    @ExitResultZero
   test  eax,eax
   jz    @ExitResultZero
   mov   ebx,[eax-4]
   test  ebx,ebx
   jle   @ExitResultZero
   mov   edi,[edx-4]
   test  edi,edi
   jle   @ExitResultZero
   cmp   edi,ecx
   jl    @ExitResultZero
   sub   edx,1
   //if SubStrLength > 1 then
   cmp   ebx,1
   jle   @CharPosEx
   mov   [esp+4],ebx
   mov   esi,edx
   mov   ebx,eax
   mov   edx,edi
   sub   edi,[esp+4]
   add   edi,1
   cmp   edi,ecx
   jl    @ExitResultZero
   mov   ebp,ecx
   lea   ecx,[esi+ebp]               //Pointer into S at Offset
   add   edi,esi                     //Points at end of S
   mov   ah,[ebx]                    //First char in SubStr
 @OuterLoopStart :
   mov   al,[ecx]
   cmp   ah,al
   jz    @InnerLoop
 @OuterLoopReentry :
   add   ecx,1
   cmp   edi,ecx
   jnl   @OuterLoopStart
   jmp   @ExitResultZero
 @InnerLoop :
   mov   edx,1
 @InnerLoopStart :
   mov   al,[ecx+edx]                //Load next char from S
   cmp   al,[ebx+edx]                //Compare to next char in SubStr
   jnz   @OuterLoopReentry
   add   edx,1
   cmp   edx,[esp+4]
   jl    @InnerLoopStart
   mov   eax,ecx
   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
   jmp   @NewExit
 @CharPosEx :
   mov   esi,edx
   mov   dl,[eax]
   mov   eax,ecx
 @CharPosExLoop :
   movzx ecx,[esi+eax]
   cmp   dl,cl
   jz    @NewExit
   add   eax,1
   cmp   edi,eax
   jnl   @CharPosExLoop
 @ExitResultZero :
   xor   eax,eax
 @NewExit :
   add   esp,8
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
end;

////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_64a(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   lea   ecx,[esi+ebp]               //Pointer into S at Offset
//   add   edi,esi                     //Points at end of S
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[ecx]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   ecx,1
//   cmp   edi,ecx
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[ecx+ebp]                //Load next char from S
//   cmp   dl,[ebx+ebp]                //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]
//   jl    @InnerLoopStart
//   mov   eax,ecx
//   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_64b(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   lea   ecx,[esi+ebp]               //Pointer into S at Offset
//   add   edi,esi                     //Points at end of S
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[ecx]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   ecx,1
//   cmp   edi,ecx
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[ecx+ebp]                //Load next char from S
//   cmp   dl,[ebx+ebp]                //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]
//   jl    @InnerLoopStart
//   mov   eax,ecx
//   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_64c(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   lea   ecx,[esi+ebp]               //Pointer into S at Offset
//   add   edi,esi                     //Points at end of S
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[ecx]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   ecx,1
//   cmp   edi,ecx
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[ecx+ebp]                //Load next char from S
//   cmp   dl,[ebx+ebp]                //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]
//   jl    @InnerLoopStart
//   mov   eax,ecx
//   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_64d(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   lea   ecx,[esi+ebp]               //Pointer into S at Offset
//   add   edi,esi                     //Points at end of S
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[ecx]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   ecx,1
//   cmp   edi,ecx
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[ecx+ebp]                //Load next char from S
//   cmp   dl,[ebx+ebp]                //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]
//   jl    @InnerLoopStart
//   mov   eax,ecx
//   sub   eax,esi                     //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_65a(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_65b(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_65c(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              29/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_65d(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   sub   edx,1
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   mov   [esp+4],ebx
//   mov   esi,edx
//   mov   ebx,eax
//   mov   edx,edi
//   sub   edi,[esp+4]
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              30/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_66a(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   sub   edx,1
//   mov   esi,edx
//   mov   edx,edi
//   sub   edi,ebx
//   mov   [esp+4],ebx
//   mov   ebx,eax
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   sub   edx,1
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              30/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_66b(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   sub   edx,1
//   mov   esi,edx
//   mov   edx,edi
//   sub   edi,ebx
//   mov   [esp+4],ebx
//   mov   ebx,eax
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   sub   edx,1
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              30/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_66c(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   sub   edx,1
//   mov   esi,edx
//   mov   edx,edi
//   sub   edi,ebx
//   mov   [esp+4],ebx
//   mov   ebx,eax
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   sub   edx,1
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;
//
////Author:            Dennis Kjaer Christensen
////Date:              30/3 2005
////Instructionset(s): IA32
//
//function PosEx_DKC_IA32_66d(const SubStr, S: string; Offset: Integer = 1): Integer;
//asm
//   push  ebx
//   push  esi
//   push  edi
//   push  ebp
//   sub   esp,8
//   //if (Offset <= 0) then
//   test  ecx,ecx
//   jle   @ExitResultZero
//   test  edx,edx
//   jz    @ExitResultZero
//   test  eax,eax
//   jz    @ExitResultZero
//   mov   ebx,[eax-4]
//   test  ebx,ebx
//   jle   @ExitResultZero
//   mov   edi,[edx-4]
//   test  edi,edi
//   jle   @ExitResultZero
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   //if SubStrLength > 1 then
//   cmp   ebx,1
//   jle   @CharPosEx
//   sub   edx,1
//   mov   esi,edx
//   mov   edx,edi
//   sub   edi,ebx
//   mov   [esp+4],ebx
//   mov   ebx,eax
//   add   edi,1
//   cmp   edi,ecx
//   jl    @ExitResultZero
//   mov   ebp,ecx
//   mov   [esp],esi
//   add   edi,esi                     //Points at end of S
//   lea   esi,[esi+ebp]               //Pointer into S at Offset
//   mov   al,[ebx]                    //First char in SubStr
// @OuterLoopStart :
//   movzx edx,[esi]
//   cmp   al,dl
//   jz    @InnerLoop
// @OuterLoopReentry :
//   add   esi,1
//   cmp   edi,esi
//   jnl   @OuterLoopStart
//   jmp   @ExitResultZero
// @InnerLoop :
//   mov   ebp,1
// @InnerLoopStart :
//   movzx edx,[esi+ebp]               //Load next char from S
//   movzx ecx,[ebx+ebp]               //Load next char from SubStr
//   cmp   dl,cl                       //Compare to next char in SubStr
//   jnz   @OuterLoopReentry
//   add   ebp,1
//   cmp   ebp,[esp+4]                 //Need register for SubStrLength
//   jl    @InnerLoopStart
//   mov   eax,esi
//   sub   eax,[esp]                   //Calculate Pos as pointer into S at hit - pointer to start of S
//   jmp   @NewExit
// @CharPosEx :
//   sub   edx,1
//   mov   esi,edx
//   mov   dl,[eax]
//   mov   eax,ecx
// @CharPosExLoop :
//   movzx ecx,[esi+eax]
//   cmp   dl,cl
//   jz    @NewExit
//   add   eax,1
//   cmp   edi,eax
//   jnl   @CharPosExLoop
// @ExitResultZero :
//   xor   eax,eax
// @NewExit :
//   add   esp,8
//   pop   ebp
//   pop   edi
//   pop   esi
//   pop   ebx
//end;

initialization
 Filler1;
 Filler2;
 Filler3;
 Filler4;
 Filler5;
 Filler6;

end.
