unit CompareMemDKCUnit;

interface

function CompareMem_DKC_Pas_9_a(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_Pas_9_b(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_Pas_9_c(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_Pas_9_d(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_6_a(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_6_b(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_6_c(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_6_d(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_7_a(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_7_b(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_7_c(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_IA32_7_d(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_MMX_1_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_MMX_1_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_MMX_1_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_MMX_1_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_1_a(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_SSE2_1_b(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_SSE2_1_c(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_SSE2_1_d(P1, P2: Pointer; Length: Integer): Boolean;//+
function CompareMem_DKC_SSE2_2_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_2_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_2_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_2_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_3_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_3_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_3_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_3_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_4_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_4_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_4_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_4_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_5_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_5_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_5_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_5_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_6_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_6_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_6_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_6_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_7_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_7_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_7_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_7_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_8_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_8_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_8_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_8_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_9_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_9_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_9_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_9_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_10_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_10_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_10_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_10_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_11_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_11_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_11_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_11_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_12_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_12_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_12_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE2_12_d(P1, P2: Pointer; Length: Integer): Boolean;

function CompareMem_DKC_SSE3_1_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_1_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_1_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_1_d(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_2_a(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_2_b(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_2_c(P1, P2: Pointer; Length: Integer): Boolean;
function CompareMem_DKC_SSE3_2_d(P1, P2: Pointer; Length: Integer): Boolean;

implementation

//Author:            Dennis Kjaer Christensen
//Date:              8/4 2005
//Instructionset(s): IA32

function CompareMem_DKC_Pas_9_a(P1, P2: Pointer; Length: Integer): Boolean;
var
 PChar1, PChar2, EndPChar : PChar;
 PInt1, PInt2, EndPInt : PInteger;
label
 ResultFalseExit;

begin
 if Length <= 0 then
  begin
   Result := True;
   Exit;
  end;
 PChar1 := P1;
 PChar2 := P2;
 Result := True;
 EndPChar := PChar1 + Length;
 if Length < 16 then
  begin
   repeat
    if PChar1^ <> PChar2^ then
     goto ResultFalseExit;
    Inc(PChar1);
    Inc(PChar2);
   until(PChar1 >= EndPChar);
   Exit;
  end
 else
  begin
   PInt1 := P1;
   PInt2 := P2;
   EndPInt := PInteger(Integer(PInt1) + Length);
   Dec(EndPInt,4);
   repeat
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
   until(Integer(PInt1) > Integer(EndPInt));
   Inc(EndPInt,4);
   if Integer(PInt1) < Integer(EndPInt) then
    begin
     PChar1 := PChar(PInt1);
     PChar2 := PChar(PInt2);
     repeat
      if PChar1^ <> PChar2^ then
       goto ResultFalseExit;
      Inc(PChar1);
      Inc(PChar2);
     until(PChar1 >= EndPChar);
     Exit;
    end
   else
    Exit;
  end;
ResultFalseExit :
 Result := False;
end;

procedure Filler1;
asm
 nop
end;

function CompareMem_DKC_Pas_9_b(P1, P2: Pointer; Length: Integer): Boolean;
var
 PChar1, PChar2, EndPChar : PChar;
 PInt1, PInt2, EndPInt : PInteger;
label
 ResultFalseExit;

begin
 if Length <= 0 then
  begin
   Result := True;
   Exit;
  end;
 PChar1 := P1;
 PChar2 := P2;
 Result := True;
 EndPChar := PChar1 + Length;
 if Length < 16 then
  begin
   repeat
    if PChar1^ <> PChar2^ then
     goto ResultFalseExit;
    Inc(PChar1);
    Inc(PChar2);
   until(PChar1 >= EndPChar);
   Exit;
  end
 else
  begin
   PInt1 := P1;
   PInt2 := P2;
   EndPInt := PInteger(Integer(PInt1) + Length);
   Dec(EndPInt,4);
   repeat
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
   until(Integer(PInt1) > Integer(EndPInt));
   Inc(EndPInt,4);
   if Integer(PInt1) < Integer(EndPInt) then
    begin
     PChar1 := PChar(PInt1);
     PChar2 := PChar(PInt2);
     repeat
      if PChar1^ <> PChar2^ then
       goto ResultFalseExit;
      Inc(PChar1);
      Inc(PChar2);
     until(PChar1 >= EndPChar);
     Exit;
    end
   else
    Exit;
  end;
ResultFalseExit :
 Result := False;
end;

function CompareMem_DKC_Pas_9_c(P1, P2: Pointer; Length: Integer): Boolean;
var
 PChar1, PChar2, EndPChar : PChar;
 PInt1, PInt2, EndPInt : PInteger;
label
 ResultFalseExit;

begin
 if Length <= 0 then
  begin
   Result := True;
   Exit;
  end;
 PChar1 := P1;
 PChar2 := P2;
 Result := True;
 EndPChar := PChar1 + Length;
 if Length < 16 then
  begin
   repeat
    if PChar1^ <> PChar2^ then
     goto ResultFalseExit;
    Inc(PChar1);
    Inc(PChar2);
   until(PChar1 >= EndPChar);
   Exit;
  end
 else
  begin
   PInt1 := P1;
   PInt2 := P2;
   EndPInt := PInteger(Integer(PInt1) + Length);
   Dec(EndPInt,4);
   repeat
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
   until(Integer(PInt1) > Integer(EndPInt));
   Inc(EndPInt,4);
   if Integer(PInt1) < Integer(EndPInt) then
    begin
     PChar1 := PChar(PInt1);
     PChar2 := PChar(PInt2);
     repeat
      if PChar1^ <> PChar2^ then
       goto ResultFalseExit;
      Inc(PChar1);
      Inc(PChar2);
     until(PChar1 >= EndPChar);
     Exit;
    end
   else
    Exit;
  end;
ResultFalseExit :
 Result := False;
end;

procedure Filler3;
asm
 nop
end;

function CompareMem_DKC_Pas_9_d(P1, P2: Pointer; Length: Integer): Boolean;
var
 PChar1, PChar2, EndPChar : PChar;
 PInt1, PInt2, EndPInt : PInteger;
label
 ResultFalseExit;

begin
 if Length <= 0 then
  begin
   Result := True;
   Exit;
  end;
 PChar1 := P1;
 PChar2 := P2;
 Result := True;
 EndPChar := PChar1 + Length;
 if Length < 16 then
  begin
   repeat
    if PChar1^ <> PChar2^ then
     goto ResultFalseExit;
    Inc(PChar1);
    Inc(PChar2);
   until(PChar1 >= EndPChar);
   Exit;
  end
 else
  begin
   PInt1 := P1;
   PInt2 := P2;
   EndPInt := PInteger(Integer(PInt1) + Length);
   Dec(EndPInt,4);
   repeat
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
    if PInt1^ <> PInt2^ then
     goto ResultFalseExit;
    Inc(PInt1);
    Inc(PInt2);
   until(Integer(PInt1) > Integer(EndPInt));
   Inc(EndPInt,4);
   if Integer(PInt1) < Integer(EndPInt) then
    begin
     PChar1 := PChar(PInt1);
     PChar2 := PChar(PInt2);
     repeat
      if PChar1^ <> PChar2^ then
       goto ResultFalseExit;
      Inc(PChar1);
      Inc(PChar2);
     until(PChar1 >= EndPChar);
     Exit;
    end
   else
    Exit;
  end;
ResultFalseExit :
 Result := False;
end;

procedure Filler7;
asm
 nop
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/4 2005
//Instructionset(s): IA32

function CompareMem_DKC_IA32_6_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   eax,4
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   cmp   edi,ecx
   jle   @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler8;
asm
 nop
end;

function CompareMem_DKC_IA32_6_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   eax,4
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   cmp   edi,ecx
   jle   @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler9;
asm
 nop
end;

function CompareMem_DKC_IA32_6_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   eax,4
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   cmp   edi,ecx
   jle   @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler10;
asm
 nop
end;

function CompareMem_DKC_IA32_6_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   eax,4
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   mov   ebx,[edi]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edi,4
   add   esi,4
   cmp   edi,ecx
   jle   @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/4 2005
//Instructionset(s): IA32

function CompareMem_DKC_IA32_7_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jbe   @Loop1End
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
 @Loop1End :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   ebp,4
   sub   ebp,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,ebp
   add   esi,ebp
   mov   edx,edi
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   cmp   edx,ecx
   jle   @Loop3Start
   mov   edi,edx
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
   mov   edi,edx
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler11;
asm
 nop
end;

function CompareMem_DKC_IA32_7_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jbe   @Loop1End
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
 @Loop1End :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   ebp,4
   sub   ebp,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,ebp
   add   esi,ebp
   mov   edx,edi
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   cmp   edx,ecx
   jle   @Loop3Start
   mov   edi,edx
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
   mov   edi,edx
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler12;
asm
 nop
end;

function CompareMem_DKC_IA32_7_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jbe   @Loop1End
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
 @Loop1End :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   ebp,4
   sub   ebp,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,ebp
   add   esi,ebp
   mov   edx,edi
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   cmp   edx,ecx
   jle   @Loop3Start
   mov   edi,edx
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
   mov   edi,edx
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

procedure Filler13;
asm
 nop
end;

function CompareMem_DKC_IA32_7_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   push  ebp
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jbe   @Loop1End
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
 @Loop1End :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,3
   mov   ebp,4
   sub   ebp,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   add   edi,ebp
   add   esi,ebp
   mov   edx,edi
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   mov   ebx,[edx]
   cmp   ebx,[esi]
   jnz   @ResultFalseExit
   add   edx,4
   add   esi,4
   cmp   edx,ecx
   jle   @Loop3Start
   mov   edi,edx
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
   mov   edi,edx
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   xor   eax,eax
   add   eax,1
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   xor   eax,eax
   pop   ebp
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/4 2005
//Instructionset(s): IA32

function CompareMem_DKC_MMX_1_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,7
   mov   eax,8
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   mov   edx,[edi+4]
   cmp   edx,[esi+4]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   cmp      edi,ecx
   jle      @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   emms
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   emms
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

function CompareMem_DKC_MMX_1_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,7
   mov   eax,8
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   mov   edx,[edi+4]
   cmp   edx,[esi+4]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   cmp      edi,ecx
   jle      @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   emms
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   emms
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

function CompareMem_DKC_MMX_1_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,7
   mov   eax,8
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   mov   edx,[edi+4]
   cmp   edx,[esi+4]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   cmp      edi,ecx
   jle      @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   emms
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   emms
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

function CompareMem_DKC_MMX_1_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push  ebx
   push  esi
   push  edi
   test  ecx,ecx
   jle   @ResultTrueExit
   mov   edi,eax
   mov   esi,edx
   lea   eax,[ecx+edi]
   cmp   ecx,32
   jnl   @IfEnd2
 @Loop1Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   eax,edi
   jnbe  @Loop1Start
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @IfEnd2 :
   mov   edx,edi
   and   edx,7
   mov   eax,8
   sub   eax,edx
   mov   ebx,edi
   mov   edx,[edi]
   cmp   edx,[esi]
   jnz   @ResultFalseExit
   mov   edx,[edi+4]
   cmp   edx,[esi+4]
   jnz   @ResultFalseExit
   add   edi,eax
   add   esi,eax
   add   ecx,ebx
   sub   ecx,16
 @Loop3Start :
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   movq     mm0, [edi]
   movq     mm1, [esi]
   pcmpeqb  mm1, mm0
   packsswb mm1, mm1
   movd     ebx, mm1
   cmp      ebx, $FFFFFFFF
   jnz      @ResultFalseExit
   add      edi,8
   add      esi,8
   cmp      edi,ecx
   jle      @Loop3Start
   add   ecx,16
   cmp   edi,ecx
   jnl   @ResultTrueExit
 @Loop4Start :
   movzx edx,[edi]
   cmp   dl,[esi]
   jnz   @ResultFalseExit
   add   edi,1
   add   esi,1
   cmp   ecx,edi
   jnbe  @Loop4Start
 @ResultTrueExit :
   emms
   xor   eax,eax
   add   eax,1
   pop   edi
   pop   esi
   pop   ebx
   ret
 @ResultFalseExit :
   emms
   xor   eax,eax
   pop   edi
   pop   esi
   pop   ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              10/4 2005
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_1_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

procedure Filler14;
asm
 nop
end;

function CompareMem_DKC_SSE2_1_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

procedure Filler15;
asm
 nop
end;

function CompareMem_DKC_SSE2_1_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

procedure Filler16;
asm
 nop
end;

function CompareMem_DKC_SSE2_1_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              2/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_2_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jbe      @Loop1End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_2_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jbe      @Loop1End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler17;
asm
 nop
end;

function CompareMem_DKC_SSE2_2_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jbe      @Loop1End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_2_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jbe      @Loop1End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              2/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_3_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      eax,16
   add      esi,16
   cmp      eax,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jbe      @Loop4End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_3_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      eax,16
   add      esi,16
   cmp      eax,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jbe      @Loop4End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler18;
asm
 nop
end;

function CompareMem_DKC_SSE2_3_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      eax,16
   add      esi,16
   cmp      eax,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jbe      @Loop4End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_3_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      eax,16
   add      esi,16
   cmp      eax,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jbe      @Loop4End
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              2/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_4_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_4_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler19;
asm
 nop
end;

function CompareMem_DKC_SSE2_4_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_4_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              2/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_5_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,64
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_5_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,64
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler20;
asm
 nop
end;

function CompareMem_DKC_SSE2_5_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,64
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_5_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,64
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      esi,edx
   lea      edi,[ecx+eax]
   mov      edx,eax
   and      edx,15
   mov      edi,16
   sub      edi,edx
   mov      ebx,eax
   mov      edx,[eax]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[eax+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[eax+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[eax+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      eax,edi
   add      esi,edi
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jnle     @Loop3End
   movdqa   xmm0,[eax]
   movdqu   xmm1,[esi]
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      bx,$FFFF
   jnz      @ResultFalseExit
   add      esi,16
   add      eax,16
   cmp      eax,ecx
   jle      @Loop3Start
 @Loop3End :
   add      ecx,16
   cmp      eax,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   cmp      ecx,eax
   jbe      @Loop4End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      eax,1
   add      esi,1
   cmp      ecx,eax
   jnbe     @Loop4Start
 @Loop4End :
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_6_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_6_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler21;
asm
 nop
end;

function CompareMem_DKC_SSE2_6_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_6_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,32
   jnl      @IfEnd2
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @IfEnd2 :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_7_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler22;
asm
 nop
end;

function CompareMem_DKC_SSE2_7_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler23;
asm
 nop
end;

function CompareMem_DKC_SSE2_7_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler24;
asm
 nop
end;

function CompareMem_DKC_SSE2_7_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_8_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,8
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler25;
asm
 nop
end;

function CompareMem_DKC_SSE2_8_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,8
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler26;
asm
 nop
end;

function CompareMem_DKC_SSE2_8_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,8
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler27;
asm
 nop
end;

function CompareMem_DKC_SSE2_8_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,8
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,128
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_9_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler28;
asm
 nop
end;

function CompareMem_DKC_SSE2_9_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler29;
asm
 nop
end;

function CompareMem_DKC_SSE2_9_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler30;
asm
 nop
end;

function CompareMem_DKC_SSE2_9_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_10_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_10_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler31;
asm
 nop
end;

function CompareMem_DKC_SSE2_10_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_10_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_11_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   movdqu   xmm0,[esi+16]
   pcmpeqb  xmm0,[edi+16]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_11_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   movdqu   xmm0,[esi+16]
   pcmpeqb  xmm0,[edi+16]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_11_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   movdqu   xmm0,[esi+16]
   pcmpeqb  xmm0,[edi+16]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_11_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,32
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   movdqu   xmm0,[esi+16]
   pcmpeqb  xmm0,[edi+16]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,32
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2

function CompareMem_DKC_SSE2_12_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_12_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_12_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

function CompareMem_DKC_SSE2_12_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqu   xmm0,[esi]
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              11/4 2005
//Instructionset(s): IA32, SSE2, SSE3

function CompareMem_DKC_SSE3_1_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   movq     mm0,[edi]
   movq     mm1,[esi]
   pcmpeqb  mm0,mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   movq     mm0, [edi+8]
   movq     mm1, [esi+8]
   pcmpeqb  mm0, mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[edi]
   //lddqu xmm1, [esi]
   db $F2 db $0F db $F0 db $0E
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   emms
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   emms
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;


function CompareMem_DKC_SSE3_1_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   movq     mm0,[edi]
   movq     mm1,[esi]
   pcmpeqb  mm0,mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   movq     mm0, [edi+8]
   movq     mm1, [esi+8]
   pcmpeqb  mm0, mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[edi]
   //lddqu xmm1, [esi]
   db $F2 db $0F db $F0 db $0E
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   emms
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   emms
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

function CompareMem_DKC_SSE3_1_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   movq     mm0,[edi]
   movq     mm1,[esi]
   pcmpeqb  mm0,mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   movq     mm0, [edi+8]
   movq     mm1, [esi+8]
   pcmpeqb  mm0, mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[edi]
   //lddqu xmm1, [esi]
   db $F2 db $0F db $F0 db $0E
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   emms
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   emms
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

function CompareMem_DKC_SSE3_1_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     ebx
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+edi]
   cmp      ecx,32
   jnl      @IfEnd2
 @Loop1Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      eax,edi
   jnbe     @Loop1Start
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @IfEnd2 :
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   movq     mm0,[edi]
   movq     mm1,[esi]
   pcmpeqb  mm0,mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   movq     mm0, [edi+8]
   movq     mm1, [esi+8]
   pcmpeqb  mm0, mm1
   pmovmskb edx,mm0
   cmp      edx,$000000FF
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   movdqa   xmm0,[edi]
   //lddqu xmm1, [esi]
   db $F2 db $0F db $F0 db $0E
   pcmpeqb  xmm0,xmm1
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   emms
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   pop      ebx
   ret
 @ResultFalseExit :
   emms
   xor      eax,eax
   pop      edi
   pop      esi
   pop      ebx
   ret
end;

//Author:            Dennis Kjaer Christensen
//Date:              3/1 2006
//Instructionset(s): IA32, SSE2, SSE3

function CompareMem_DKC_SSE3_2_a(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   //lddqu    xmm0,[esi]
   db $F2 db $0F db $F0 db $06
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler32;
asm
 nop
end;

function CompareMem_DKC_SSE3_2_b(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   //lddqu    xmm0,[esi]
   db $F2 db $0F db $F0 db $06
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler33;
asm
 nop
end;

function CompareMem_DKC_SSE3_2_c(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   //lddqu    xmm0,[esi]
   db $F2 db $0F db $F0 db $06
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

procedure Filler34;
asm
 nop
end;

function CompareMem_DKC_SSE3_2_d(P1, P2: Pointer; Length: Integer): Boolean;
asm
   push     esi
   push     edi
   test     ecx,ecx
   jle      @ResultTrueExit1
   cmp      ecx,4
   jnl      @MediumCompares
   mov      esi,edx
   lea      edi,[ecx+eax]
 @Loop1Start :
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   cmp      edi,eax
   jbe      @Loop1End
   add      esi,1
   movzx    edx,[eax]
   cmp      dl,[esi]
   jnz      @ResultFalseExit1
   add      eax,1
   add      esi,1
   cmp      edi,eax
   jnbe     @Loop1Start
 @Loop1End :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @MediumCompares :
   cmp      ecx,256
   jnl      @BigCompares
   sub      ecx,4
   xor      esi,esi
 @MediumCompareLoop :
   mov      edi,[eax+esi]
   cmp      edi,[edx+esi]
   jnz      @ResultFalseExit1
   add      esi,4
   cmp      esi,ecx
   jb       @MediumCompareLoop
   mov      edi,[eax+ecx]
   cmp      edi,[edx+ecx]
   jnz      @ResultFalseExit1
 @ResultTrueExit1 :
   xor      eax,eax
   add      eax,1
   pop      edi
   pop      esi
   ret
 @BigCompares :
   push     ebx
   mov      edi,eax
   mov      esi,edx
   lea      eax,[ecx+eax]
   mov      edx,edi
   and      edx,15
   mov      eax,16
   sub      eax,edx
   mov      ebx,edi
   mov      edx,[edi]
   cmp      edx,[esi]
   jnz      @ResultFalseExit
   mov      edx,[edi+4]
   cmp      edx,[esi+4]
   jnz      @ResultFalseExit
   mov      edx,[edi+8]
   cmp      edx,[esi+8]
   jnz      @ResultFalseExit
   mov      edx,[edi+12]
   cmp      edx,[esi+12]
   jnz      @ResultFalseExit
   add      edi,eax
   add      esi,eax
   add      ecx,ebx
   sub      ecx,16
 @Loop3Start :
   //lddqu    xmm0,[esi]
   db $F2 db $0F db $F0 db $06
   pcmpeqb  xmm0,[edi]
   pmovmskb ebx,xmm0
   cmp      ebx,$0000FFFF
   jnz      @ResultFalseExit
   add      edi,16
   add      esi,16
   cmp      edi,ecx
   jle      @Loop3Start
   add      ecx,16
   cmp      edi,ecx
   jnl      @ResultTrueExit
 @Loop4Start :
   movzx    edx,[edi]
   cmp      dl,[esi]
   jnz      @ResultFalseExit
   add      edi,1
   add      esi,1
   cmp      ecx,edi
   jnbe     @Loop4Start
 @ResultTrueExit :
   xor      eax,eax
   add      eax,1
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit :
   xor      eax,eax
   pop      ebx
   pop      edi
   pop      esi
   ret
 @ResultFalseExit1 :
   xor      eax,eax
   pop      edi
   pop      esi
   ret
end;

initialization

 Filler1;
 Filler3;
 Filler7;
 Filler8;
 Filler9;
 Filler10;
 Filler11;
 Filler12;
 Filler13;
 Filler14;
 Filler15;
 Filler16;
 Filler17;
 Filler18;
 Filler19;
 Filler20;
 Filler21;
 Filler22;
 Filler23;
 Filler24;
 Filler25;
 Filler26;
 Filler27;
 Filler28;
 Filler29;
 Filler30;
 Filler31;
 Filler32;
 Filler33;
 Filler34;

end.
